ad_library {
    Rooms procs

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: rooms-procs.tcl,v 1.1 2004/03/15 03:39:30 carolinem Exp $
}

namespace eval room-reservation::rooms {

   ad_proc -public new {
        {-room_id:required}
        {-name:required}
        {-facility_id:required}
        {-description}
        {-capacity:required}
        {-phone}
        {-approval_needed_p}
    } {
	creates a new room
    } {
	# We want unique names per facility
	if {[room-reservation::rooms::name_exists -name $name -facility_id $facility_id]} {
	    ad_return_complaint 1 "<ul><li>the name you provided is already being used.</li></ul>"
	    ad_script_abort
	}
	
        # Prepare the variables for instantiation
        set extra_vars [ns_set create]
        oacs_util::vars_to_ns_set -ns_set $extra_vars \
                   -var_list {room_id name facility_id description capacity phone approval_needed_p}

        # Instantiate the facility
        return [package_instantiate_object -extra_vars $extra_vars rr_room]
    }

   ad_proc -public edit {
       {-room_id:required}
       {-name:required}
       {-facility_id:required}
       {-description}
       {-capacity:required}
       {-phone}
       {-approval_needed_p}
   } {
       edits properties of an existing facility
   } {
	# We want unique names per facility
       set name_exists_p [room-reservation::rooms::name_exists -name $name -facility_id $facility_id]
       if {$name_exists_p && ![string equal $name_exists_p $room_id]} {
	   ad_return_complaint 1 "<ul><li>the name you provided is already being used.</li></ul>"
	   ad_script_abort
       }
       set edit_user [ad_conn user_id]
       set edit_ip [ad_conn peeraddr]

       return [db_exec_plsql edit_room {}]
   }
   
   ad_proc -public delete {
       {-room_id:required}
   } {
       deletes a currently enabled room
   } {
       return [db_string delete_room {}]
   }
   
   ad_proc -public disable {
       {-room_id:required}
       {-facility_id:required}
   } {
       disables a currently enabled room
   } {
       return [db_dml disable_room {}]
   }
   
   ad_proc -public enable {
       {-room_id:required}
       {-facility_id:required}
   } {
       enables a currently enabled room
   } {
       return [db_dml enable_room {}]
   }
   

   ad_proc -public get {
       {-room_id:required}
       {-array:required}
   } {
       Get the data for one room
   } {
       upvar $array row
       
       db_1row select_room_data {} -column_array row
   }
   
   ad_proc -public get_name {
       {-room_id:required}
   } {
       Gets the name of a room.
       Returns empty string if room not found.
   } {
       return [db_string select_room_name {} -default ""]
   }
        
   ad_proc -public get_facility_id {
       {-room_id:required}
   } {
       Gets the associated facility_id of a room.  Returns 0 if room not found.
   } {
       return [db_string select_facility_id {} -default 0]
   }
        
   ad_proc -public get_full_name {
       {-room_id:required}
   } {
       Gets the full name of a room (facility name + room name).
       Returns empty string if room not found
   } {
       set room_name [room-reservation::rooms::get_name -room_id $room_id]
       if {[string equal $room_name ""]} {
	   return ""
       } else {
	   set full_room_name [room-reservation::facilities::get_name \
				   -facility_id [room-reservation::rooms::get_facility_id -room_id $room_id] \
				  ]
	   append full_room_name ", $room_name"
	   return $full_room_name
       }
   }
        
    ad_proc -public name_exists {
        {-name:required}
        {-facility_id:required}
    } {
        Checks if a room name already exists for a particular facility
    } {
        return [db_string check_name {} -default 0]
    }

    ad_proc -public get_reservations_list_of_ns_sets {
        {-room_id ""}
        {-status_list ""}
        {-facilities_enabled_p "t"}
        {-rooms_enabled_p "t"}
        {-reserving_user ""}
	{-package_id ""}
    } {
        Returns a list_of_ns_sets of reservations for this room
        whose state is in state_list.  Convert to a multirow source
        in the calling environment via template::util::list_of_ns_sets_to_multirow
    } {
        set condition_list [list]
	if {![empty_string_p $room_id]} {
	    lappend condition_list "fr.room_id = '$room_id' "
	}
	if {[exists_and_not_null status_list]} {
	    set formatted_list [list]
	    foreach status $status_list {
		# sanity check if it's passing us valid vars
		if {![empty_string_p $status]} {
		    lappend formatted_list "'$status'"
		}
	    }
	    # did we actually get anything?
	    if {[llength $formatted_list]} {
		lappend condition_list "status in ([join $formatted_list ,]) "
	    }
	}
	if {![empty_string_p $reserving_user]} {
	    lappend condition_list "reserving_user = '$reserving_user' "
	}
	if {[string equal "f" $facilities_enabled_p]} {
	    set facilities_table rr_facilities
	} else {
	    set facilities_table rr_facilities_enabled
	}
	if {![empty_string_p $package_id]} {
	    lappend condition_list "package_id = '$package_id' "
	}
	if {[string equal "f" $rooms_enabled_p]} {
	    set rooms_table rr_rooms
	} else {
	    set rooms_table rr_rooms_enabled
	}
	if {[llength $condition_list]} {
	    
	    set condition_sql "where [join $condition_list " and "]"
	}
        return [db_list_of_ns_sets select_reservations {}]
    }

}
