<?xml version="1.0"?>
<queryset>
   <rdbms><type>postgresql</type><version>7.1</version></rdbms>


<fullquery name="room-reservation::rooms::edit.edit_room">
<querytext>

  select rr_rooms__edit(:room_id,
                                :name,
                                :facility_id,
                                :description,
                                :capacity,
                                :phone,
                                :approval_needed_p,
				:edit_user,
				:edit_ip)

</querytext>
</fullquery>


<fullquery name="room-reservation::rooms::delete.delete_room">
<querytext>

  select rr_rooms__delete(:room_id)

</querytext>
</fullquery>


<fullquery name="room-reservation::rooms::get_name.select_room_name">
<querytext>

  select rr_rooms__name(:room_id)

</querytext>
</fullquery>


<fullquery name="room-reservation::rooms::get_reservations_list_of_ns_sets.select_reservations">
<querytext>

    select r.reservation_id,
           f.name as facility_name,
           fr.name as room_name,
	   r.status,
           to_char(start_date, 'Mon DD, YYYY HH12:MI AM') as full_start_date,
           to_char(end_date, 'Mon DD, YYYY HH12:MI AM') as full_end_date,
           e.name,
           p.first_names||' '||p.last_name as username
    from   acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
           join time_intervals t
               on (s.interval_id = t.interval_id)
           join rr_reservations r
               on (e.event_id = r.reservation_id)
           join $rooms_table fr
               on (r.room_id = fr.room_id)
           join $facilities_table f
               on (f.facility_id = fr.facility_id)
           join persons p
               on (r.reserving_user = p.person_id)
           $condition_sql
    order by start_date

</querytext>
</fullquery>


</queryset>

