ad_library {
    Facility Reservation procs

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: room-reservation-procs.tcl,v 1.1 2004/03/15 03:39:30 carolinem Exp $
}

namespace eval room-reservation {

    ad_proc -public package_key {} {
	returns the package key
    } {
	return "room-reservation"
    }

    ad_proc -public expire_stale_items {} {
	expires stale items
    } {
	set expiry_days [parameter::get -parameter ExpiryDays -default 30]

	if {$expiry_days} {
	    set expired_list [db_list get_expired_reservations {}]
	    
	    foreach reservation_id $expired_list {
		db_exec_plsql expire_reservation {}
	    }
	}

	return 0
    }

    ad_proc -public get_facilities_pretty_name {} {
	returns the package key
    } {
	return [util_memoize "parameter::get -parameter FacilitiesPrettyName -default Facility"]
    }

    ad_proc -public get_facilities_pretty_plural {} {
	returns the package key
    } {
	return [util_memoize "parameter::get -parameter FacilitiesPrettyPlural -default Facilities"]
    }

    ad_proc -public get_rooms_pretty_name {} {
	returns the package key
    } {
	return [util_memoize "parameter::get -parameter RoomsPrettyName -default Room"]
    }

    ad_proc -public get_rooms_pretty_plural {} {
	returns the package key
    } {
	return [util_memoize "parameter::get -parameter RoomsPrettyPlural -default Rooms"]
    }

    ad_proc -public get_ui_params {
	{-facilities_pretty_name}
	{-facilities_pretty_plural}
	{-rooms_pretty_name}
	{-rooms_pretty_plural}
    } {
	assigns the cached stuff for UI to passed in variables
    } {
	if {[exists_and_not_null facilities_pretty_name]} {
	    upvar 1 $facilities_pretty_name var 
	    set var [room-reservation::get_facilities_pretty_name]
	}
	if {[exists_and_not_null facilities_pretty_plural]} {
	    upvar 1 $facilities_pretty_plural var 
	    set var [room-reservation::get_facilities_pretty_plural]
	}
	if {[exists_and_not_null rooms_pretty_name]} {
	    upvar 1 $rooms_pretty_name var 
	    set var [room-reservation::get_rooms_pretty_name]
	}
	if {[exists_and_not_null rooms_pretty_plural]} {
	    upvar 1 $rooms_pretty_plural var 
	    set var [room-reservation::get_rooms_pretty_plural]
	}
	return 0
    }

    ad_proc -public flush_parameters {} {
	flushes all the cached parameters for the package
    } {
	util_memoize_flush "parameter::get -parameter FacilitiesPrettyName -default Facility"
	util_memoize_flush "parameter::get -parameter FacilitiesPrettyPlural -default Facilities"
	util_memoize_flush "parameter::get -parameter RoomsPrettyName -default Room"
	util_memoize_flush "parameter::get -parameter RoomsPrettyPlural -default Rooms"
	return 0
    }

}
