ad_library {
    Reservations procs

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: reservations-procs.tcl,v 1.1 2004/03/15 03:39:30 carolinem Exp $
}

namespace eval room-reservation::reservations {

   ad_proc -public new {
       {-name:required}
       {-room_id:required}
       {-start_date:required}
       {-end_date:required}
       {-attendees}
       {-note}
       {-contact_person}
       {-contact_email}
       {-contact_phone}
   } {
       creates a new reservation
   } {
       
       db_transaction {
	   
	   set creation_user [ad_conn user_id]
	   set creation_ip [ad_conn peeraddr]
	   # create the activity here
	   set activity_name "Facility Reservation"
	   set activity_id [db_exec_plsql insert_activity {}]
	   
	   # set the date_format
	   set date_format "YYYY-MM-DD HH24:MI"
	   
	   # find out the timespan_id
	   set timespan_id [db_exec_plsql insert_timespan {}]
	   
	   # create the reservation
	   # Pre-fetch the reservation_id
	   set reservation_id [db_nextval acs_object_id_seq]
	   
	   set reservation_id [db_exec_plsql insert_reservation {}]

	   return $reservation_id
       }
       
   }
   
   ad_proc -public edit {
       {-reservation_id:required}
       {-name:required}
       {-room_id:required}
       {-start_date:required}
       {-end_date:required}
       {-attendees}
       {-note}
       {-contact_person}
       {-contact_email}
       {-contact_phone}
   } {
       edits an existing reservation
   } {
       
       db_transaction {
	   
	   # set the date_format
	   set date_format "YYYY-MM-DD HH24:MI"

	   # update the events
	   db_dml update_event ""
	   
	   # update the time interval based on the timespan id
	   
	   db_1row get_interval_id ""
	   
	   db_exec_plsql update_interval {}

	   # call edit procedure
	   set edit_user [ad_conn user_id]
	   set edit_ip [ad_conn peeraddr]

	   db_exec_plsql update_reservation {}
	   return $reservation_id
       }
       
   }
   
   ad_proc -public get_status {
       {-reservation_id:required}
   } {
       gets the status of a reservation
   } {
       return [db_string select_status {}]
   }
   
   ad_proc -public cancel {
       {-reservation_id:required}
       {-reason ""}
   } {
       cancels a reservation
   } {
       set action_user [ad_conn user_id]
       set action_ip [ad_conn peeraddr]

       return [db_string cancel_reservation {}]
   }
   
   ad_proc -public approve {
       {-reservation_id:required}
       {-reason ""}
   } {
       approves a reservation
   } {
       set action_user [ad_conn user_id]
       set action_ip [ad_conn peeraddr]

       return [db_string approve_reservation {}]
   }
   
   ad_proc -public reject {
       {-reservation_id:required}
       {-reason ""}
   } {
       rejects a reservation
   } {
       set action_user [ad_conn user_id]
       set action_ip [ad_conn peeraddr]

       return [db_string reject_reservation {}]
   }
   
   ad_proc -public get {
       {-reservation_id:required}
       {-array:required}
   } {
       Get the data for one reservation
   } {
       upvar $array row
       
       db_1row select_reservation_data {} -column_array row
   }
   
   ad_proc -public check_conflict_p {
       {-reservation_id "0"}
       {-room_id:required}
       {-start_date:required}
       {-end_date:required}
   } {
       checks for a time conflict
   } {
       if {[db_exec_plsql check_conflict {}]} {
	   return 1
       } else {
	   return 0
       }

   }
   
   ad_proc -public get_conflict_ids {
       {-reservation_id "0"}
       {-room_id:required}
       {-start_date:required}
       {-end_date:required}
   } {
       returns a list of the conflicting ids for this reservation attemp
   } {
       return [db_list select_ids {}]
   }
   
   ad_proc -public get_simultaneous_pending_ids {
       {-reservation_id "0"}
       {-room_id:required}
       {-start_date:required}
       {-end_date:required}
   } {
       returns a list of ids of the pending reservations that is simultaneous with this reservation
   } {
       return [db_list select_ids {}]
   }
   
   ad_proc -public get_room_id {
       {-reservation_id:required}
   } {
       gets the room_id of a reservation
   } {
       return [db_string select_room_id {} -default 0]
   }
   
   ad_proc -public owner_p {
       {-reservation_id:required}
       {-user_id:required}
   } {
       checks if the user_id is the reserving_user
   } {
       return [db_string reserving_user_p {} -default 0]
   }
   
}
