<?xml version="1.0"?>

<queryset>
  <rdbms><type>postgresql</type><version>7.1</version></rdbms>


    <fullquery name="room-reservation::reservations::new.insert_activity">
      <querytext>

	select acs_activity__new (
					null,
					:activity_name,
					null,
					'f',
					null,
					'acs_activity', 
					now(),
					:creation_user,
					:creation_ip,
					:room_id
	)

      </querytext>
    </fullquery>


    <fullquery name="room-reservation::reservations::new.insert_timespan">
      <querytext>

	select timespan__new (    
					:start_date::timestamp,
					:end_date::timestamp
	) 

      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::new.insert_reservation">
      <querytext>

	select rr_reservations__new (    
					:reservation_id,
                                        'rr_reservation',
					:name,
                                        :room_id,
                                        :creation_user,
                                        :attendees,
                                        :note,
                                        :contact_person,
                                        :contact_email,
                                        :contact_phone,
					:timespan_id,
					:activity_id,
					now(),
					:creation_user,
					:creation_ip,
					:room_id
	) 

      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::edit.update_interval">
      <querytext>

	select time_interval__edit (
					:interval_id,
					:start_date::timestamp,
					:end_date::timestamp
	)

      </querytext>
    </fullquery>



    <fullquery name="room-reservation::reservations::edit.update_reservation">
      <querytext>

	select rr_reservations__edit (
					:reservation_id,
                                        :room_id,
					:attendees,
					:note,
                                        :contact_person,
                                        :contact_email,
                                        :contact_phone,
					:edit_user,
					:edit_ip

	)

      </querytext>
    </fullquery>



    <fullquery name="room-reservation::reservations::get_status.select_status">
      <querytext>

	select rr_reservations__get_status (    
					:reservation_id
	) 

      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::cancel.cancel_reservation">
      <querytext>

	select rr_reservations__cancel (    
					:reservation_id,
                                        :reason,
                                        :action_user,
					:action_ip
	) 

      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::approve.approve_reservation">
      <querytext>

	select rr_reservations__approve (    
					:reservation_id,
                                        :reason,
                                        :action_user,
					:action_ip
	) 

      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::reject.reject_reservation">
      <querytext>

	select rr_reservations__reject (    
					:reservation_id,
                                        :reason,
                                        :action_user,
					:action_ip
	) 

      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::get.select_reservation_data">
      <querytext>

        select r.room_id,
               r.reservation_id,
               coalesce(e.name, a.name) as name,
               r.attendees,
               r.note,
               r.contact_person,
               r.contact_email,
               r.contact_phone,
               r.status,
               r.reason,
	       to_char(r.action_date, 'Month DD, YYYY  HH:MI AM') as full_action_date,
	       f.name as facility_name,
	       fr.name as room_name,
	       r.status,
	       to_char(start_date, 'Month DD, YYYY  HH:MI AM') as full_start_date,
	       to_char(end_date, 'Month DD, YYYY  HH:MI AM') as full_end_date,
	       to_char(start_date, 'HH12:MIam') as start_time,
	       to_char(end_date, 'HH12:MIam') as end_time,
	       to_char(end_date, 'YYYY-MM-DD') as date,
	       to_char(start_date, 'YYYY-MM-DD HH24:MI') as start_date,
	       to_char(end_date, 'YYYY-MM-DD HH24:MI') as end_date,
               p.first_names||' '||p.last_name as username
        from   acs_events e join timespans s
	          on (e.timespan_id = s.timespan_id)
	       join time_intervals t
	          on (s.interval_id = t.interval_id)
               join acs_activities a
                  on (e.activity_id = a.activity_id)
	       join rr_reservations r
	          on (e.event_id = r.reservation_id)
	       join rr_rooms fr
	          on (r.room_id = fr.room_id)
	       join rr_facilities f
	          on (f.facility_id = fr.facility_id)
               join persons p
                  on (r.reserving_user = p.person_id)
        where  r.reservation_id = :reservation_id
      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::check_conflict_p.check_conflict">
      <querytext>

	select rr_reservations__conflict_p (
                                        :reservation_id,    
					:room_id,
                                        :start_date::timestamp,
                                        :end_date::timestamp
	) 

      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::get_conflict_ids.select_ids">
      <querytext>

	select r.reservation_id
   	from acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
             join time_intervals t
               on (s.interval_id = t.interval_id)
             join rr_reservations r
               on (e.event_id = r.reservation_id)
	where r.room_id = :room_id and
              not (r.reservation_id = :reservation_id) and
              r.status in ('approved', 'rejected') and
	      ((:start_date >= start_date and :start_date < end_date) or
	       (start_date >= :start_date and start_date < :end_date));

      </querytext>
    </fullquery>

 
    <fullquery name="room-reservation::reservations::get_simultaneous_pending_ids.select_ids">
      <querytext>

	select r.reservation_id
   	from acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
             join time_intervals t
               on (s.interval_id = t.interval_id)
             join rr_reservations r
               on (e.event_id = r.reservation_id)
	where r.room_id = :room_id and
              not (r.reservation_id = :reservation_id) and
              r.status = 'pending' and
	      ((:start_date >= start_date and :start_date < end_date) or
	       (start_date >= :start_date and start_date < :end_date));

      </querytext>
    </fullquery>

 
</queryset>
