<?xml version="1.0"?>
<queryset>


<fullquery name="room-reservation::facilities::disable.disable_facility">
<querytext>

    update rr_facilities
    set enabled_p = 'f'
    where facility_id = :facility_id and
          package_id = :package_id

</querytext>
</fullquery>


<fullquery name="room-reservation::facilities::enable.enable_facility">
<querytext>

    update rr_facilities
    set enabled_p = 't'
    where facility_id = :facility_id and
          package_id = :package_id

</querytext>
</fullquery>


<fullquery name="room-reservation::facilities::get.select_facility_data">
<querytext>

    select name,
           description
    from rr_facilities
    where facility_id = :facility_id and
          package_id = :package_id

</querytext>
</fullquery>


<fullquery name="room-reservation::facilities::name_exists.check_name">
<querytext>

    select facility_id
    from rr_facilities
    where UPPER(name) = UPPER(:name) and
          package_id = :package_id

</querytext>
</fullquery>


<fullquery name="room-reservation::facilities::get_name_id_list_enabled.select_name_id">
<querytext>

    select name, facility_id
    from rr_facilities_enabled
    where package_id = :package_id

</querytext>
</fullquery>


<fullquery name="room-reservation::facilities::get_name_id_list_enabled_and_non_empty.select_name_id">
<querytext>

    select name, facility_id
    from rr_facilities_enabled f
    where package_id = :package_id and
          (select count(room_id)
           from   rr_rooms_enabled r
           where  r.facility_id = f.facility_id) > 0

</querytext>
</fullquery>


<fullquery name="room-reservation::facilities::get_room_list.select_room_ids">
<querytext>

    select room_id
    from rr_rooms
    where facility_id = :facility_id

</querytext>
</fullquery>


</queryset>
