ad_library {
    Facilities procs

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: facilities-procs.tcl,v 1.1 2004/03/15 03:39:30 carolinem Exp $
}

namespace eval room-reservation::facilities {

   ad_proc -public new {
        {-facility_id:required}
        {-name:required}
        {-description}
        {-package_id:required}
    } {
	creates a new facility
    } {
	# We want unique names
	if {[room-reservation::facilities::name_exists -name $name]} {
	    ad_return_complaint 1 "<ul><li>the name you provided is already being used.</li></ul>"
	    ad_script_abort
	}
	
        # Prepare the variables for instantiation
        set extra_vars [ns_set create]
        oacs_util::vars_to_ns_set -ns_set $extra_vars \
                   -var_list {facility_id name description package_id}

        # Instantiate the facility
        return [package_instantiate_object -extra_vars $extra_vars rr_facility]
    }

   ad_proc -public edit {
        {-facility_id:required}
        {-name:required}
        {-description}
        {-package_id:required}
    } {
	edits properties of an existing facility
    } {
	# We want unique names
	set name_exists_p [room-reservation::facilities::name_exists -name $name]
	if {$name_exists_p && ![string equal $name_exists_p $facility_id]} {
	    ad_return_complaint 1 "<ul><li>the name you provided is already being used.</li></ul>"
	    ad_script_abort
	}
	set edit_user [ad_conn user_id]
	set edit_ip [ad_conn peeraddr]

        return [db_exec_plsql edit_facility {}]
    }

   ad_proc -public delete {
        {-facility_id:required}
    } {
	delete a facility
    } {
        return [db_string delete_facility {}]
    }

   ad_proc -public disable {
        {-facility_id:required}
    } {
	disables a currently enabled facility
    } {
	set package_id [ad_conn package_id]
        return [db_dml disable_facility {}]
    }

   ad_proc -public enable {
        {-facility_id:required}
    } {
	enables a currently disabled facility
    } {
	set package_id [ad_conn package_id]
        return [db_dml enable_facility {}]
    }

    ad_proc -public get {
        {-facility_id:required}
        {-array:required}
    } {
        Get the data for one facility
    } {
	set package_id [ad_conn package_id]
        upvar $array row

        db_1row select_facility_data {} -column_array row
    }
        
    ad_proc -public get_name {
        {-facility_id:required}
    } {
        Gets the name of a facility
    } {
        return [db_string select_facility_name {} -default "Unnamed"]
    }
        
    ad_proc -public name_exists {
        {-name:required}
        {-package_id ""}
    } {
        Checks if a facility name already exists
    } {
	if [string equal $package_id ""] {
	    set package_id [ad_conn package_id]
	}
        return [db_string check_name {} -default 0]
    }
        
    ad_proc -public get_name_id_list_enabled {
        {-package_id ""}
    } {
        Returns a list of lists consisting of facility ids and names
    } {
	if [string equal $package_id ""] {
	    set package_id [ad_conn package_id]
	}
        return [db_list_of_lists select_name_id {}]
    }
        
    ad_proc -public get_name_id_list_enabled_and_non_empty {
        {-package_id ""}
    } {
        Returns a list of lists consisting of facility ids and names who have enabled rooms
    } {
	if [string equal $package_id ""] {
	    set package_id [ad_conn package_id]
	}
        return [db_list_of_lists select_name_id {}]
    }
        
    ad_proc -public get_room_list {
        {-facility_id:required}
    } {
        Returns a list or room ids for a given facility_id
    } {
        return [db_list select_room_ids {}]
    }
        
}
