ad_library {
    Date and Time procs

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: datetime-procs.tcl,v 1.1 2004/03/15 03:39:30 carolinem Exp $
}

namespace eval room-reservation::datetime {

    ad_proc -public convert_to_sql {
        {-date:required}
        {-time:required}
    } {
	creates a sql formatted date given a date chunk and a time chunk
    } {
	set year [template::util::date::get_property year $date]
	set month [template::util::date::get_property month $date]
	set day [template::util::date::get_property day $date]
	set hours [template::util::date::get_property hours $time]
	set minutes [template::util::date::get_property minutes $time]
        return "$year-$month-$day $hours:$minutes"
    }
    
    ad_proc -public check_valid_end_date_p {
        {-date:required}
    } {
	checks that end date has not yet passed
    } {
	return [db_string valid_p {}]
    }
    
    ad_proc -public check_valid_dates_p {
        {-start_date:required}
        {-end_date:required}
    } {
	checks that start date comes before end date
    } {
	return [db_string valid_p {}]
    }
    
    ad_proc -public check_valid_year_p {
        {-start_date:required}
    } {
	checks that start date falls within allowable year range
    } {
	set future_years "[parameter::get -parameter FutureYears -default 5] years"
	return [db_string valid_p {}]
    }
    
}
