ad_library {
    Calendar Display and Navigation procs

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-08-28
    @cvs-id $Id: calendar-procs.tcl,v 1.1 2004/03/15 03:39:30 carolinem Exp $
}

namespace eval room-reservation::calendar {

    ad_proc -public one_day_display {
        {-room_id:required}
        {-date ""}
        {-hour_template {$hour}}
        {-item_template {$item}}
        {-prev_nav_template {<a href="?date=$yesterday">&lt;</a>}}
        {-next_nav_template {<a href="?date=$tomorrow">&gt;</a>}}
        {-start_hour 0}
        {-end_hour 23}
    } {
        Creates a day widget containing all reservations for said date
    } {
        set widget_start_hour $start_hour
        set widget_end_hour $end_hour

        set date_format "YYYY-MM-DD HH24:MI"

        if {[empty_string_p $date]} {
            set date [dt_sysdate]
        }

        set current_date $date

        set items [ns_set create]

        # Loop through the calendars
	db_foreach select_day_reservations {} {

	    set item $name
	    set item_subst [subst $item_template]
	    
	    set item "<b>$pretty_start_date - $pretty_end_date</b>: $item_subst (status: $status)"
	    
	    set ns_set_pos $start_hour
	    
	    ns_set put $items $ns_set_pos [list $start_date $end_date $item]
        }

        set hour {$display_hour}
        set start_time {$hour}
        set end_time {$next_hour}
        
        set hour_template [subst $hour_template]
        
        return [dt_widget_day -hour_template $hour_template \
                -prev_nav_template $prev_nav_template \
                -next_nav_template $next_nav_template \
                -start_hour $widget_start_hour -end_hour $widget_end_hour \
                -calendar_details $items -date $date -overlap_p 1]
        
    }

    ad_proc -public list_display {
        {-room_id:required}
        {-date ""}
        {-start_date ""}
        {-end_date ""}
        {-item_template {$item}}
    } {
        create a list display of reservations
    } {

        set date_format "YYYY-MM-DD HH24:MI"
        set current_date $date
        set items [ns_set create]
        
	db_foreach select_list_reservations {} {
	    set item "$name"
	    set item [subst $item_template]
	    
	    ns_set put $items $start_hour [list $pretty_date $pretty_start_date $pretty_end_date $pretty_weekday $item $status]
	}
            
        return [room-reservation::calendar::dt_widget_list -item_template $item_template \
                -calendar_details $items \
                -start_date $start_date \
                -end_date $end_date \
                ]
        
    }

    ad_proc -public one_week_display {
        {-room_id:required}
        {-date ""}
        {-day_template "<a href=?date=\$date>\$day &nbsp; - &nbsp; \$pretty_date</a>"}
        {-item_template "<a href=?action=room-view&room_id=\$room_id>\$item</a>"}
        {-item_add_template ""}
        {-prev_nav_template ""}
        {-next_nav_template ""}
    } {
        Creates a week widget for reservations
    } {
        if {[empty_string_p $date]} {
            set date [dt_sysdate]
        }

        set current_date $date

        set items [ns_set create]

        db_1row select_weekday_info {}

        # Loop through the calendars
	db_foreach select_week_reservations {} {
	    set item "$name (status: $status)"
	    set item_details "[subst $item_template]"
	    
	    set time_details "<b>$pretty_start_date - $pretty_end_date</b>:"

	    set item "$time_details $item_details"
	    
	    ns_set put $items $start_date_julian $item
        }

        # display stuff
        
        if {[empty_string_p $item_add_template]} {
            set day_number_template "$day_template"
        } else {
            set day_number_template "$day_template &nbsp; &nbsp; $item_add_template"
        }
        
        return [dt_widget_week -calendar_details $items -date $date -day_template $day_number_template -prev_week_template $prev_nav_template -next_week_template $next_nav_template]
        
    }

    ad_proc -public dt_widget_list {
	{-calendar_details:required}
	{-item_template {$item}}
	{-start_date ""}
	{-end_date ""}
    } {
        create a list display of reservations
    } {

	if {[ns_set size $calendar_details] == 0} {
	    return "<i>No Items</i>"
	}
        
	# The title
	if {[empty_string_p $start_date] && [empty_string_p $end_date]} {
	    set title "All Items"
	}
	
	if {[empty_string_p $start_date] && ![empty_string_p $end_date]} {
	    set title "Items until [util_AnsiDatetoPrettyDate $end_date]"
	}
	
	if {![empty_string_p $start_date] && [empty_string_p $end_date]} {
	    set title "Items starting [util_AnsiDatetoPrettyDate $start_date]"
	}
	
	if {![empty_string_p $start_date] && ![empty_string_p $end_date]} {
	    set title "Items from [util_AnsiDatetoPrettyDate $start_date] to [util_AnsiDatetoPrettyDate $end_date]"
	}
	
	set return_html "<b>$title</b><p>"


	# Create the header
	append return_html "
        <table border=0 cellspacing=0 cellpadding=1>
        <tr bgcolor=black><td bgcolor>
        <table border=0 cellspacing=1 cellpadding=2>
        <tr bgcolor=#aaaaaa><th>Day of Week</th><th>Date</th><th>Start Time</th><th>End Time</th>
        <th>Event</th>
        <th>Status</th></tr>\n"

	set flip 0
	
	# Loop through the events, and add them
	set flip 0
	for {set i 0} {$i < [ns_set size $calendar_details]} {incr i} {
	    set item [ns_set value $calendar_details $i]
	    set date [lindex $item 0]
	    set start_time [lindex $item 1]
	    set end_time [lindex $item 2]
	    set weekday [lindex $item 3]
	    set event_name [lindex $item 4]
	    set status [lindex $item 5]
	    
	    if {[expr $flip % 2] == 0} {
		set bgcolor white
	    } else {
		set bgcolor #dddddd
	    }
	    
       append return_html "
        <tr bgcolor=$bgcolor><td>$weekday</td><td>$date</td><td>$start_time</td><td>$end_time</td><td>$event_name</td><td>$status</td></tr>\n"
	    incr flip
	}
	
	append return_html "</table></td></tr></table>\n"
	
	return $return_html
    }
    
    ad_proc -public one_month_display {
	{-room_id:required}
	{-day_template "<a href=?julian_date=\$julian_date>\$day_number</a>"}
        {-item_template "<a href=?action=edit&cal_item_id=\$item_id>\$item</a>"}
        {-item_add_template ""}
        {-date ""}
        {-prev_nav_template ""}
        {-next_nav_template ""}
    } {
        Creates a month widget for reservations
    } {
        if {[empty_string_p $date]} {
            set date [dt_systime]
        }

        set items [ns_set create]
	
	db_foreach select_monthly_reservations {} {
	    set item "$name (status: $status)"
	    set item "[subst $item_template]"
	    
	    if {![dt_no_time_p -start_time $start_time -end_time $end_time]} {
		set item "<font size=-2><b>$start_time - $end_time</b></font> $item"
	    }
	    
	    append item "<br>"
	    
	    ns_set put $items $start_date $item
	}            

        
        # Display stuff
        if {[empty_string_p $item_add_template]} {
            set day_number_template "<font size=1>$day_template</font>"
        } else {
            set day_number_template "<font size=1>$day_template &nbsp; &nbsp; $item_add_template</font>"
        }

        return [dt_widget_month -calendar_details $items -date $date \
                -master_bgcolor black \
                -header_bgcolor lavender \
                -header_text_color black \
                -header_text_size "+1" \
                -day_header_bgcolor lavender \
                -day_bgcolor white \
                -today_bgcolor #FFF8DC \
                -empty_bgcolor lightgrey \
                -day_text_color black \
                -prev_next_links_in_title 1 \
                -prev_month_template $prev_nav_template \
                -next_month_template $next_nav_template \
                -day_number_template $day_number_template]
    }

    
}