<?xml version="1.0"?>
<queryset>
   <rdbms><type>postgresql</type><version>7.1</version></rdbms>


<fullquery name="room-reservation::calendar::one_day_display.select_day_reservations">
<querytext>

    select r.reservation_id,
	   r.status,
           to_char(start_date, 'HH:MIpm') as pretty_start_date,
           to_char(end_date, 'HH:MIpm') as pretty_end_date,
	   to_char(start_date, 'HH24') as start_hour,
           to_char(start_date, 'HH24:MI') as start_date,
           to_char(end_date, 'HH24:MI') as end_date,
           e.name
    from   acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
           join time_intervals t
               on (s.interval_id = t.interval_id)
           join rr_reservations r
               on (e.event_id = r.reservation_id)
    where  r.room_id = :room_id and
           start_date >= to_date(:current_date,:date_format) and
           start_date < to_date(:current_date,:date_format) + 1
</querytext>
</fullquery>


<fullquery name="room-reservation::calendar::list_display.select_list_reservations">
<querytext>

    select r.reservation_id,
	   r.status,
	   to_char(start_date, 'HH24') as start_hour,
           to_char(start_date, 'MM/DD/YYYY') as pretty_date,
           to_char(start_date, 'Day') as pretty_weekday,
           to_char(start_date, 'HH:MIpm') as pretty_start_date,
           to_char(end_date, 'HH:MIpm') as pretty_end_date,
           e.name
    from   acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
           join time_intervals t
               on (s.interval_id = t.interval_id)
           join rr_reservations r
               on (e.event_id = r.reservation_id)
    where  r.room_id = :room_id and
           (start_date > to_date(:start_date,:date_format) or :start_date is null) and
           (start_date < to_date(:end_date,:date_format) or :end_date is null)

</querytext>
</fullquery>


<fullquery name="room-reservation::calendar::one_week_display.select_weekday_info">
<querytext>
        select   to_char(to_date(:current_date, 'yyyy-mm-dd'), 'D') 
        as       day_of_the_week,
        to_char(next_day(to_date(:current_date, 'yyyy-mm-dd')- '1 week'::timespan, 'Sunday'), 'YYYY-MM-DD')
        as       sunday_of_the_week,
        to_char(next_day(to_date(:current_date, 'yyyy-mm-dd'), 'Saturday'), 'YYYY-MM-DD')
        as       saturday_of_the_week
        from     dual
</querytext>
</fullquery>


<fullquery name="room-reservation::calendar::one_week_display.select_week_reservations">
<querytext>

    select r.reservation_id,
	   r.status,
	   to_char(start_date, 'J') as start_date_julian,
           to_char(start_date, 'HH:MIpm') as pretty_start_date,
           to_char(end_date, 'HH:MIpm') as pretty_end_date,
           to_char(start_date,'HH24:MI') as start_date,
           to_char(end_date,'HH24:MI') as end_date,
           e.name
    from   acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
           join time_intervals t
               on (s.interval_id = t.interval_id)
           join rr_reservations r
               on (e.event_id = r.reservation_id)
    where  r.room_id = :room_id and
           start_date between
              to_date(:sunday_of_the_week,'YYYY-MM-DD') and
              to_date(:saturday_of_the_week,'YYYY-MM-DD')

</querytext>
</fullquery>


<fullquery name="room-reservation::calendar::one_month_display.select_monthly_reservations">
<querytext>

    select r.reservation_id,
	   r.status,
	   to_char(start_date, 'J') as start_date,
           to_char(start_date, 'HH:MIpm') as start_time,
           to_char(end_date, 'HH:MIpm') as end_time,
           e.name
    from   acs_events e join timespans s
               on (e.timespan_id = s.timespan_id)
           join time_intervals t
               on (s.interval_id = t.interval_id)
           join rr_reservations r
               on (e.event_id = r.reservation_id)
    where  r.room_id = :room_id
    order by start_date,end_date	

</querytext>
</fullquery>


</queryset>
