-- Room Reservation Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-08-28
-- @cvs-id $Id: rooms-drop.sql,v 1.1 2004/03/15 03:39:30 carolinem Exp $
--
-- Total rewrite though some
-- concepts were taken from the old
-- ACS3.x Room Reservation package

-- let's remove permissions (PARANOIA)
delete from acs_permissions where object_id in (select room_id from rr_rooms);

-- let's do the views stuff
drop view rr_rooms_enabled;
drop view rr_rooms_disabled;

-- let's do the table stuff
drop table rr_rooms;

-- let's remove our objects and our object type

create function inline_0 ()
returns integer as '
declare
    object_rec	record;
begin
   -- drop objects first
   for object_rec in select object_id from acs_objects where object_type=''rr_room''
      loop
         PERFORM acs_object__delete( object_rec.object_id );
      end loop;

    -- drop the type 
    perform acs_object_type__drop_type (
        ''rr_room'', ''f''
    );

    return null;
end;' language 'plpgsql';

select inline_0();
drop function inline_0 ();

