-- Room Reservation Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-08-28
-- @cvs-id $Id: facilities-package-create.sql,v 1.1 2004/03/15 03:39:30 carolinem Exp $
--
-- Total rewrite though some
-- concepts were taken from the old
-- ACS3.x Room Reservation package

-- let's create helper functions
select define_function_args('rr_facilities__new','facility_id,object_type;rr_facility,name,description,package_id,creation_date,creation_user,creation_ip,context_id');

create or replace function rr_facilities__new (integer,varchar,varchar,varchar,integer,timestamp,integer,varchar,integer)
returns integer as '
declare
    p_facility_id                 alias for $1;
    p_object_type                 alias for $2;
    p_name                        alias for $3;
    p_description                 alias for $4;
    p_package_id                  alias for $5;
    p_creation_date               alias for $6;
    p_creation_user               alias for $7;
    p_creation_ip                 alias for $8;
    p_context_id                  alias for $9;
    v_facility_id                 integer;
begin
    v_facility_id:= acs_object__new(
        p_facility_id,
        p_object_type,
        p_creation_date,
        p_creation_user,
        p_creation_ip,
        coalesce(p_context_id, p_package_id)
    );

    insert into rr_facilities
    (facility_id, name, description, package_id)
    values
    (v_facility_id, p_name, p_description, p_package_id);

    perform acs_object__update_last_modified(coalesce(p_context_id, p_package_id), p_creation_user, p_creation_ip);

    return v_facility_id;
end;
' language 'plpgsql';

select define_function_args('rr_facilities__edit','facility_id,name,description,package_id,edit_user,edit_ip');

create or replace function rr_facilities__edit (integer,varchar,varchar,integer,integer,varchar)
returns integer as '
declare
    p_facility_id                 alias for $1;
    p_name                        alias for $2;
    p_description                 alias for $3;
    p_package_id                  alias for $4;
    p_edit_user			  alias for $5;
    p_edit_ip			  alias for $6;
begin
    update rr_facilities
    set name = p_name,
        description = p_description
    where facility_id = p_facility_id and
          package_id = p_package_id;

    perform acs_object__update_last_modified(p_facility_id, p_edit_user, p_edit_ip);

    return 0;
end;
' language 'plpgsql';

select define_function_args('rr_facilities__name','facility_id');

create or replace function rr_facilities__name(integer)
returns varchar as '
declare
    p_facility_id                      alias for $1;
begin
    return name from rr_facilities where facility_id = p_facility_id;
end;
' language 'plpgsql';


-- delete a facility
select define_function_args('rr_facilities__delete','facility_id');

create or replace function rr_facilities__delete(integer)
returns integer as '
declare
    p_facility_id                      alias for $1;
begin
    perform acs_object__delete(p_facility_id);
    return 0;
end;
' language 'plpgsql';
