-- Room Reservation Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-08-28
-- @cvs-id $Id: facilities-drop.sql,v 1.1 2004/03/15 03:39:30 carolinem Exp $
--
-- Total rewrite though some
-- concepts were taken from the old
-- ACS3.x Room Reservation package

-- let's do the permissions stuff
create function inline_0()
returns integer as '
begin
    -- temporarily drop this trigger to avoid a data-change violation 
    -- on acs_privilege_hierarchy_index while updating the child privileges.
    drop trigger acs_priv_hier_ins_del_tr on acs_privilege_hierarchy;

    -- remove children
    perform acs_privilege__remove_child(''room_reservation_admin'',''room_reservation_modify'');
    perform acs_privilege__remove_child(''room_reservation_admin'',''room_reservation_delete'');
    perform acs_privilege__remove_child(''room_reservation_admin'',''room_reservation_create'');
    perform acs_privilege__remove_child(''room_reservation_admin'',''room_reservation_view'');

    perform acs_privilege__remove_child(''admin'',''room_reservation_admin'');

    perform acs_privilege__remove_child(''delete'',''room_reservation_delete'');
    perform acs_privilege__remove_child(''read'',''room_reservation_view'');
    perform acs_privilege__remove_child(''write'',''room_reservation_modify'');

    -- re-enable the trigger before the last insert to force the 
    -- acs_privilege_hierarchy_index table to be updated.
    create trigger acs_priv_hier_ins_del_tr after insert or delete
    on acs_privilege_hierarchy for each row
    execute procedure acs_priv_hier_ins_del_tr ();

    perform acs_privilege__remove_child(''create'',''room_reservation_create'');

    perform acs_privilege__drop_privilege(''room_reservation_admin'');
    perform acs_privilege__drop_privilege(''room_reservation_modify'');
    perform acs_privilege__drop_privilege(''room_reservation_delete'');
    perform acs_privilege__drop_privilege(''room_reservation_create'');
    perform acs_privilege__drop_privilege(''room_reservation_view'');

    return null;
end;' language 'plpgsql';

select inline_0();
drop function inline_0();

-- let's remove permissions (PARANOIA)
delete from acs_permissions where object_id in (select facility_id from rr_facilities);

-- let's do the views stuff
drop view rr_facilities_enabled;
drop view rr_facilities_disabled;

-- let's do the table stuff
drop table rr_facilities;

-- let's remove our objects and our object type

create function inline_0 ()
returns integer as '
declare
    object_rec	record;
begin
   -- drop objects first
   for object_rec in select object_id from acs_objects where object_type=''rr_facility''
      loop
         PERFORM acs_object__delete( object_rec.object_id );
      end loop;

    -- drop the type 
    perform acs_object_type__drop_type (
        ''rr_facility'', ''f''
    );

    return null;
end;' language 'plpgsql';

select inline_0();
drop function inline_0 ();

