-- Room Reservation Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-08-28
-- @cvs-id $Id: facilities-create.sql,v 1.1 2004/03/15 03:39:30 carolinem Exp $
--
-- Total rewrite though some
-- concepts were taken from the old
-- ACS3.x Room Reservation package

-- let's do the permissions stuff
begin;
    select acs_privilege__create_privilege('room_reservation_view',null,null);
    select acs_privilege__create_privilege('room_reservation_create',null,null);
    select acs_privilege__create_privilege('room_reservation_delete',null,null);
    select acs_privilege__create_privilege('room_reservation_modify',null,null);
    select acs_privilege__create_privilege('room_reservation_admin','Room Reservations Administrator',null);

    -- temporarily drop this trigger to avoid a data-change violation 
    -- on acs_privilege_hierarchy_index while updating the child privileges.

    drop trigger acs_priv_hier_ins_del_tr on acs_privilege_hierarchy;

    -- bind privileges to global names
    select acs_privilege__add_child('create','room_reservation_create');
    select acs_privilege__add_child('write','room_reservation_modify');
    select acs_privilege__add_child('read','room_reservation_view');
    select acs_privilege__add_child('delete','room_reservation_delete');

    select acs_privilege__add_child('admin','room_reservation_admin');


    select acs_privilege__add_child('room_reservation_admin','room_reservation_view');
    select acs_privilege__add_child('room_reservation_admin','room_reservation_create');
    select acs_privilege__add_child('room_reservation_admin','room_reservation_delete');

    -- re-enable the trigger before the last insert to force the 
    -- acs_privilege_hierarchy_index table to be updated.

    create trigger acs_priv_hier_ins_del_tr after insert or delete
    on acs_privilege_hierarchy for each row
    execute procedure acs_priv_hier_ins_del_tr ();

    select acs_privilege__add_child('room_reservation_admin','room_reservation_modify');
end;

-- let's do the table stuff
create table rr_facilities (
    facility_id                     integer
                                    constraint rr_facilities_facility_id_nn
                                    not null
                                    constraint rr_facilities_facility_id_fk
                                    references acs_objects (object_id)
                                    constraint rr_facilities_facility_id_pk
                                    primary key,
    name                            varchar(200)
                                    constraint rr_facilities_name_un
                                    unique
                                    constraint rr_facilities_name_nn
                                    not null,
    description                     varchar(400),
    enabled_p                       char(1)
                                    default 't'
                                    constraint rr_facilities_enabled_p_nn
                                    not null
                                    constraint rr_facilities_enabled_p_ck
                                    check (enabled_p in ('t','f')),
    -- to keep track of instances
    package_id                      integer
                                    constraint rr_facilities_package_id_nn
                                    not null
);

-- let's do the views stuff
create view rr_facilities_enabled
as
    select *
    from rr_facilities
    where enabled_p = 't';

create view rr_facilities_disabled
as
    select *
    from rr_facilities
    where enabled_p = 'f';

-- let's create our object
create function inline_0 ()
returns integer as'
begin
    perform acs_object_type__create_type(
        ''rr_facility'',         -- object_type
        ''Facility'',            -- pretty_name
        ''Facilities'',          -- pretty_plural
        ''acs_object'',          -- supertype
        ''rr_facilities'',       -- table_name
        ''facility_id'',         -- id_column
        ''rr_facilities'',       -- package_name
        ''f'',                   -- abstract_p
        null,                    -- type_extensions_table
        ''rr_facilities__name''  -- name_method
    );

    return null;
end;' language 'plpgsql';

select inline_0();
drop function inline_0();
