-- Room Reservation Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-08-28
-- @cvs-id $Id: rooms-package-create.sql,v 1.1 2004/03/15 03:39:30 carolinem Exp $
--
-- Total rewrite though some
-- concepts were taken from the old
-- ACS3.x Room Reservation package

-- let's create helper functions
select define_function_args('rr_rooms__new','room_id,object_type;rr_room,name,facility_id,description,capacity,phone,approval_needed_p,creation_date,creation_user,creation_ip,context_id');

create or replace function rr_rooms__new (integer,varchar,varchar,integer,varchar,integer,varchar,char,timestamp,integer,varchar,integer)
returns integer as '
declare
    p_room_id                     alias for $1;
    p_object_type                 alias for $2;
    p_name                        alias for $3;
    p_facility_id                 alias for $4;
    p_description                 alias for $5;
    p_capacity                    alias for $6;
    p_phone                       alias for $7;
    p_approval_needed_p           alias for $8;
    p_creation_date               alias for $9;
    p_creation_user               alias for $10;
    p_creation_ip                 alias for $11;
    p_context_id                  alias for $12;
    v_room_id                     integer;
begin
    v_room_id:= acs_object__new(
        p_room_id,
        p_object_type,
        p_creation_date,
        p_creation_user,
        p_creation_ip,
        coalesce(p_context_id, p_facility_id)
    );

    insert into rr_rooms
    (room_id, name, facility_id, description, capacity, phone, approval_needed_p)
    values
    (v_room_id, p_name, p_facility_id, p_description, p_capacity, p_phone, p_approval_needed_p);

    perform acs_object__update_last_modified(p_room_id, p_creation_user, p_creation_ip);

    return v_room_id;
end;
' language 'plpgsql';

select define_function_args('rr_rooms__edit','room_id,name,facility_id,description,capacity,phone,approval_needed_p,edit_user,edit_ip');

create or replace function rr_rooms__edit (integer,varchar,integer,varchar,integer,varchar,char,integer,varchar)
returns integer as '
declare
    p_room_id                     alias for $1;
    p_name                        alias for $2;
    p_facility_id                 alias for $3;
    p_description                 alias for $4;
    p_capacity                    alias for $5;
    p_phone                       alias for $6;
    p_approval_needed_p           alias for $7;
    p_edit_user			  alias for $8;
    p_edit_ip			  alias for $9;
begin
-- we check on facility_id just 
-- to protect from url surgery hacks
    update rr_rooms
    set name = p_name,
        description = p_description,
        capacity = p_capacity,
        phone = p_phone,
        approval_needed_p = p_approval_needed_p
    where room_id = p_room_id and
          facility_id = p_facility_id;

    perform acs_object__update_last_modified(p_room_id,p_edit_user,p_edit_ip);

    return 0;
end;
' language 'plpgsql';

select define_function_args('rr_rooms__name','room_id');

create or replace function rr_rooms__name(integer)
returns varchar as '
declare
    p_room_id                      alias for $1;
begin
    return name from rr_rooms where room_id = p_room_id;
end;
' language 'plpgsql';


-- delete a room
select define_function_args('rr_rooms__delete','room_id');

create or replace function rr_rooms__delete(integer)
returns integer as '
declare
    p_room_id                      alias for $1;
begin
    perform acs_object__delete(p_room_id);
    return 0;
end;
' language 'plpgsql';
