-- Room Reservation Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-08-28
-- @cvs-id $Id: rooms-create.sql,v 1.1 2004/03/15 03:39:30 carolinem Exp $
--
-- Total rewrite though some
-- concepts were taken from the old
-- ACS3.x Room Reservation package

-- let's do the table stuff
create table rr_rooms (
    room_id                         integer
                                    constraint rr_rooms_room_id_nn
                                    not null
                                    constraint rr_rooms_room_id_fk
                                    references acs_objects (object_id)
                                    constraint rr_rooms_room_id_pk
                                    primary key,
    name                            varchar(200)
                                    constraint rr_rooms_name_nn
                                    not null,
    facility_id                     integer
                                    constraint rr_rooms_facility_id_nn
                                    not null
                                    constraint rr_rooms_facility_id_fk
                                    references rr_facilities (facility_id),
    description                     varchar(400),
    capacity                        integer 
                                    constraint rr_rooms_capacity_nn
                                    not null,
    phone                           varchar(50),
    -- is this an open facility?
    approval_needed_p               char(1)
                                    default 't'
                                    constraint rr_rooms_approval_needed_p_nn
                                    not null
                                    constraint rr_rooms_approval_needed_p_ck
                                    check (approval_needed_p in ('t','f')),
    enabled_p                       char(1)
                                    default 't'
                                    constraint rr_rooms_enabled_p_nn
                                    not null
                                    constraint rr_rooms_enabled_p_ck
                                    check (enabled_p in ('t','f')),
                                    constraint rr_rooms_name_un
                                    unique (name, facility_id)
);


-- let's do the views stuff
create view rr_rooms_enabled
as
    select *
    from rr_rooms
    where enabled_p = 't';

create view rr_rooms_disabled
as
    select *
    from rr_rooms
    where enabled_p = 'f';

-- let's create our object
create function inline_0 ()
returns integer as'
begin
    perform acs_object_type__create_type(
        ''rr_room'',                -- object_type
        ''Room'',                   -- pretty_name
        ''Rooms'',                  -- pretty_plural
        ''acs_object'',             -- supertype
        ''rr_rooms'',               -- table_name
        ''room_id'',                -- id_column
        ''rr_rooms'',               -- package_name
        ''f'',                      -- abstract_p
        null,                       -- type_extensions_table
        ''rr_rooms__name''  -- name_method
    );

    return null;
end;' language 'plpgsql';

select inline_0();
drop function inline_0();
