-- Room Reservation Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-08-28
-- @cvs-id $Id: reservations-drop.sql,v 1.1 2004/03/15 03:39:30 carolinem Exp $
--
-- Total rewrite though some
-- concepts were taken from the old
-- ACS3.x Room Reservation package

-- let's remove permissions (PARANOIA)
delete from acs_permissions where object_id in (select reservation_id from rr_reservations);

-- let's do the views stuff
drop view rr_reservations_approve;
drop view rr_reservations_reject;
drop view rr_reservations_pending;
drop view rr_reservations_cancel;

-- let's remove our objects

create function inline_0 ()
returns integer as '
declare
    object_rec	record;
begin
   -- drop objects first
   for object_rec in select reservation_id from rr_reservations
      loop
         PERFORM rr_reservations__delete( object_rec.reservation_id );
      end loop;

    return null;
end;' language 'plpgsql';

select inline_0();
drop function inline_0 ();

-- let's do the table stuff
drop table rr_reservations;

create function inline_1 ()
returns integer as '
declare
begin
    -- drop the type 
    perform acs_object_type__drop_type (
        ''rr_reservation'', ''f''
    );

    return null;
end;' language 'plpgsql';

select inline_1();
drop function inline_1 ();

