ad_page_contract {} -query {
    {paper_id:notnull}
    {return_url:notnull}
}

set folder_id [dotlrn_fs::get_user_root_folder -user_id [ad_conn user_id]]
research_paper::get -paper_id $paper_id -array paper

form create research_paper_create

element create research_paper_create paper_id \
    -label PaperID \
    -datatype text \
    -widget hidden \
    -value $paper_id

element create research_paper_create revision_id \
    -label RevisionID \
    -datatype text \
    -widget hidden \
    -value $paper(revision_id)

element create research_paper_create return_url \
    -label ReturnURL \
    -datatype text \
    -widget hidden \
    -value $return_url

element create research_paper_create title \
    -label Title \
    -datatype text \
    -widget text \
    -html {width 60} \
    -value $paper(title)

element create research_paper_create abstract \
    -label Abstract \
    -datatype text \
    -widget textarea \
    -html {rows 5 cols 60 wrap soft} \
    -value $paper(abstract) \
    -optional

element create research_paper_create paper_url \
    -label "URL" \
    -datatype text \
    -widget text \
    -value $paper(paper_url) \
    -optional

if {![empty_string_p $paper(revision_id)]} {
    element set_properties research_paper_create paper_url -widget hidden
}

element create research_paper_create publication_date \
    -label "Publication Date" \
    -datatype date \
    -widget date \
    -value [research_paper::from_sql_datetime -sql_date $paper(publication_date) -format "YYYY-MM-DD"]\
    -optional

element create research_paper_create type \
    -label "Type" \
    -datatype text \
    -widget text \
    -value $paper(type) \
    -optional

element create research_paper_create subject \
    -label "Subject" \
    -datatype text \
    -widget text \
    -value $paper(subject) \
    -optional

element create research_paper_create identifier \
    -label "Identifier" \
    -datatype text \
    -widget text \
    -value $paper(identifier) \
    -optional

element create research_paper_create source \
    -label "Source" \
    -datatype text \
    -widget text \
    -value $paper(source) \
    -optional

element create research_paper_create lang \
    -label "Language" \
    -datatype text \
    -widget text \
    -value $paper(lang) \
    -html {size 2 maxlength 2} \
    -optional

element create research_paper_create rights \
    -label "Rights" \
    -datatype text \
    -widget textarea \
    -value $paper(rights) \
    -html {cols 60 rows 5 wrap soft} \
    -optional

element create research_paper_create public_p \
    -label PublicP \
    -datatype text \
    -widget hidden \
    -value $paper(public_p)

if {[form is_valid research_paper_create]} {
    form get_values research_paper_create \
        paper_id revision_id return_url title abstract public_p \
	subject identifier source lang paper_url publication_date type rights

    set publication_date [research_paper::to_sql_date -date $publication_date]

    research_paper::edit \
        -paper_id $paper_id \
        -title $title \
	-type $type \
	-subject $subject \
	-identifier $identifier \
	-source $source \
	-lang $lang \
	-paper_url $paper_url \
	-publication_date $publication_date \
	-rights $rights \
        -abstract $abstract \
        -revision_id $revision_id \
        -public_p $public_p

    ad_returnredirect $return_url
}

set context_bar {{Edit a Research Paper}}

ad_return_template
