
--
-- create research paper package
--
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2002-08-19
-- @version $Id: research-papers-package-create.sql,v 1.1 2003/11/14 20:57:06 janines Exp $
--

create or replace package research_paper
as

    function new (
        paper_id                    in research_papers.paper_id%TYPE default null,
	author_id		    in research_papers.author_id%TYPE,
        revision_id                 in research_papers.revision_id%TYPE default null,
	paper_url		    in research_papers.paper_url%TYPE default null,
        title                       in research_papers.title%TYPE,
        abstract                    in research_papers.abstract%TYPE default null,
	publication_date	    in research_papers.publication_date%TYPE default null,
	type			    in research_papers.type%TYPE default null,
	subject			    in research_papers.subject%TYPE default null,
	identifier		    in research_papers.identifier%TYPE default null,
	source			    in research_papers.source%TYPE default null,
	lang			    in research_papers.lang%TYPE default null,
	rights			    in research_papers.rights%TYPE default null,
	license_url		    in research_papers.license_url%TYPE default null,
        public_p                    in research_papers.public_p%TYPE default 'f',
        object_type                 in acs_objects.object_type%TYPE default 'research_paper',
        creation_date               in acs_objects.creation_date%TYPE default sysdate,
        creation_user               in acs_objects.creation_user%TYPE,
        creation_ip                 in acs_objects.creation_ip%TYPE,
        context_id                  in acs_objects.context_id%TYPE default null
    ) return research_papers.paper_id%TYPE;

    procedure delete (
        paper_id                    in research_papers.paper_id%TYPE
    );

    function name (
        paper_id                    in research_papers.paper_id%TYPE
    ) return varchar;

end research_paper;
/
show errors

create or replace package body research_paper
as

    function new (
        paper_id                    in research_papers.paper_id%TYPE default null,
	author_id		    in research_papers.author_id%TYPE,
        revision_id                 in research_papers.revision_id%TYPE default null,
	paper_url		    in research_papers.paper_url%TYPE default null,
        title                       in research_papers.title%TYPE,
        abstract                    in research_papers.abstract%TYPE default null,
	publication_date	    in research_papers.publication_date%TYPE default null,
	type			    in research_papers.type%TYPE default null,
	subject			    in research_papers.subject%TYPE default null,
	identifier		    in research_papers.identifier%TYPE default null,
	source			    in research_papers.source%TYPE default null,
	lang			    in research_papers.lang%TYPE default null,
	rights			    in research_papers.rights%TYPE default null,
	license_url		    in research_papers.license_url%TYPE default null,
        public_p                    in research_papers.public_p%TYPE default 'f',
        object_type                 in acs_objects.object_type%TYPE default 'research_paper',
        creation_date               in acs_objects.creation_date%TYPE default sysdate,
        creation_user               in acs_objects.creation_user%TYPE,
        creation_ip                 in acs_objects.creation_ip%TYPE,
        context_id                  in acs_objects.context_id%TYPE default null
    ) return research_papers.paper_id%TYPE
    is
        v_paper_id                  research_papers.paper_id%TYPE;
    begin

        v_paper_id := acs_object.new(
            object_id => new.paper_id,
            object_type => new.object_type,
            creation_date => new.creation_date,
            creation_user => new.creation_user,
            creation_ip => new.creation_ip,
            context_id => new.context_id
        );

        insert
        into research_papers
        (paper_id, author_id, revision_id, paper_url, title, abstract, publication_date, last_updated,
	type, subject, identifier, source, lang, rights, license_url, public_p)
        values
        (v_paper_id, new.author_id, new.revision_id, new.paper_url, new.title, new.abstract, new.publication_date, sysdate,
	new.type, new.subject, new.identifier, new.source, new.lang, new.rights, new.license_url, new.public_p);

        return v_paper_id;

    end new;

    procedure delete (
        paper_id                    in research_papers.paper_id%TYPE
    )
    is
    begin

        acs_object.delete(research_paper.delete.paper_id);

    end;

    function name (
        paper_id                    in research_papers.paper_id%TYPE
    ) return varchar
    is
        v_title                     research_papers.title%TYPE;
    begin

        select title
        into v_title
        from research_papers
        where research_papers.paper_id = name.paper_id;

        return v_title;

    end;

end research_paper;
/
show errors
