
--
-- create research paper model
--
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2002-08-19
-- @version $Id: research-papers-create.sql,v 1.1 2003/11/14 20:57:06 janines Exp $
--

create table research_papers (
    paper_id                        integer
                                    constraint research_papers_paper_id_fk
                                    references acs_objects (object_id)
                                    constraint research_papers_pk
                                    primary key,
    author_id			    integer
				    constraint research_papers_author_id_fk
				    references users(user_id),
    -- there is either a revision or a URL
    revision_id                     integer
                                    constraint research_papers_revision_id_fk
                                    references cr_revisions (revision_id),
    paper_url			    varchar(500),
    title                           varchar(4000)
                                    constraint research_papers_title_nn
                                    not null,
    abstract                        varchar(4000),
    publication_date		    date,
    last_updated		    date,
    type			    varchar(200),
    subject			    varchar(1000),
    identifier			    varchar(500),
    source			    varchar(500),
    lang			    char(2),
    rights			    varchar(4000),
    license_url			    varchar(300),			    
    public_p                        char(1)
                                    default 'f'
                                    constraint research_papers_public_p_ck
                                    check (public_p in ('t', 'f'))
                                    constraint research_papers_public_p_nn
                                    not null
);

declare
begin

    acs_object_type.create_type(
        object_type => 'research_paper',
        pretty_name => 'Research Paper',
        pretty_plural => 'Research Papers',
        supertype => 'acs_object',
        table_name => 'research_papers',
        id_column => 'paper_id',
        package_name => 'research_paper',
        name_method => 'research_paper.name'
    );

end;
/
show errors

@@ research-papers-package-create.sql;
@@ research-papers-notif-create.sql;

