<?xml version="1.0"?>

<queryset>

    <fullquery name="search_papers">
        <querytext>
            select research_papers.*,
                   parties.*,
                   persons.first_names,
                   persons.last_name,
                   score(1) as the_score
            from research_papers,
                 cr_revisions,
                 parties,
                 persons
            where author_id = parties.party_id
            and author_id = persons.person_id
	    and public_p = 't'
            and research_papers.revision_id = cr_revisions.revision_id(+)
            and (   lower(research_papers.title) like '%' || :search_text || '%'
                 or contains(cr_revisions.content, :search_text, 1) > 0
                 or lower(parties.email) like '%' || :search_text || '%'
                 or lower(persons.first_names) like '%' || :search_text || '%'
                 or lower(persons.last_name) like '%' || :search_text || '%'
                 or lower(research_papers.abstract) like '%' || :search_text || '%'
                 or lower(research_papers.subject) like '%' || :search_text || '%'
                 or lower(research_papers.source) like '%' || :search_text || '%'
                 or lower(research_papers.rights) like '%' || :search_text || '%')
        </querytext>
    </fullquery>

</queryset>
