ad_page_contract {} -query {
    {item_id:notnull}
    {return_url:notnull}
    {paper_id:optional}
    {public_p f}
}

set user_id [ad_conn user_id]

# Check permission
permission::require_permission -object_id $item_id -privilege read

# Folder name
set item_name [fs::get_object_name -object_id $item_id]

db_multirow revisions select_revisions {
    select cr_revisions.revision_id,
           cr_revisions.title,
           cr_revisions.mime_type as type,
           to_char(acs_objects.last_modified, 'Month DD YYYY HH24:MI') as last_modified,
           cr_revisions.content_length as content_size
    from cr_revisions,
         acs_objects
    where cr_revisions.item_id = :item_id
    and cr_revisions.revision_id = acs_objects.object_id
    order by cr_revisions.revision_id
}

set passthrough_vars [export_vars {return_url public_p}]
if {[exists_and_not_null paper_id]} {
    append passthrough_vars "&paper_id=$paper_id"
}

set rp_context_bar ""

set context_bar {{Create a Research Paper}}

ad_return_template
