ad_page_contract {} -query {
    {folder_id:notnull}
    {return_url:notnull}
    {paper_id:optional}
    {public_p f}
}

set user_id [ad_conn user_id]

# sanity check
if {[empty_string_p $folder_id]} {
    ad_return_complaint 1 "Error: empty folder_id!"
    ad_script_abort
}

# Check permission
permission::require_permission -object_id $folder_id -privilege read

# Size of contents
set n_contents [fs::get_folder_contents_count -folder_id $folder_id -user_id $user_id]

# Folder name
set folder_name [fs::get_object_name -object_id $folder_id]

# Folder contents
set rows [fs::get_folder_contents \
    -folder_id $folder_id \
    -user_id $user_id]

template::util::list_of_ns_sets_to_multirow -rows $rows -var_name "contents"

set passthrough_vars [export_vars {return_url public_p}]
if {[exists_and_not_null paper_id]} {
    append passthrough_vars "&paper_id=$paper_id"
}

set rp_context_bar ""

set context_bar {{Create a Research Paper}}

ad_return_template
