ad_page_contract {
    page to add a new file to the system
} {
    folder_id:integer,notnull
    return_url:notnull
    {title ""}
    {lock_title_p 0}
    {paper_id ""}
    {public_p f}
} -validate {
    valid_folder -requires {folder_id:integer} {
	if ![fs_folder_p $folder_id] {
	    ad_complain "The specified parent folder is not valid."
	}
    }
} -properties {
    folder_id:onevalue
    context_bar:onevalue
    title:onevalue
    lock_title_p:onevalue
}

ad_require_permission $folder_id write

set context_bar {{Attach File}}
set fs_context_bar [fs_context_bar_list -final "Add File" $folder_id]

# if title isn't passed in ignore lock_title_p
if {[empty_string_p $title]} {
    set lock_title_p 0
}
