ad_page_contract {} {
    folder_id:integer,notnull
    upload_file:notnull,trim
    upload_file.tmpfile:tmpfile
    return_url:notnull
    title:notnull,trim
    description
    paper_id:optional
    {public_p f}
} -validate {
    valid_folder -requires {folder_id:integer} {
	if {![fs_folder_p $folder_id]} {
	    ad_complain "The specified parent folder is not valid."
	}
    }
} 

ad_require_permission $folder_id write

# get the filename part of the upload file
if {![regexp {[^//\\]+$} $upload_file filename]} {
    set filename $upload_file
}

set user_id [ad_conn user_id]
set creation_ip [ad_conn peeraddr]
set mime_type [fs_maybe_create_new_mime_type $upload_file]
set indb_p 1


db_transaction {

    if {$indb_p} {

	set file_id [db_exec_plsql new_lob_file {}]
	set revision_id [db_exec_plsql new_version {}]
	db_dml lob_content {} -blob_files [list ${upload_file.tmpfile}]
	db_dml lob_size {}

    }

}

set passthrough [export_vars {revision_id return_url public_p}]
if {[exists_and_not_null paper_id]} {
    append passthrough "&paper_id=$paper_id"
}

ad_returnredirect "add?$passthrough"
