ad_page_contract {} -query {
    {revision_id ""}
    {return_url:notnull}
    {paper_id:optional}
    {public_p f}
}

if {[exists_and_not_null paper_id]} {

    set new_revision_id $revision_id

    research_paper::get -paper_id $paper_id -array paper
    template::util::array_to_vars paper

    research_paper::edit \
        -paper_id $paper_id \
        -title $title \
        -type $type \
        -subject $subject \
        -identifier $identifier \
        -source $source \
        -lang $lang \
        -paper_url $paper_url \
        -publication_date $publication_date \
        -rights $rights \
        -abstract $abstract \
        -revision_id $revision_id \
        -public_p $public_p

    ad_returnredirect $return_url
    ad_script_abort

}

form create research_paper_create

element create research_paper_create revision_id \
    -label RevisionID \
    -datatype text \
    -widget hidden \
    -value $revision_id

element create research_paper_create public_p \
    -label public_p \
    -datatype text \
    -widget hidden \
    -value $public_p

element create research_paper_create return_url \
    -label ReturnURL \
    -datatype text \
    -widget hidden \
    -value $return_url

element create research_paper_create title \
    -label Title \
    -datatype text \
    -widget text \
    -html {width 60}

element create research_paper_create abstract \
    -label Abstract \
    -datatype text \
    -widget textarea \
    -html {rows 5 cols 60 wrap soft} \
    -optional

element create research_paper_create paper_url \
    -label "URL" \
    -datatype text \
    -widget text \
    -optional

if {![empty_string_p $revision_id]} {
    element set_properties research_paper_create paper_url -widget hidden
}

element create research_paper_create publication_date \
    -label "Publication Date" \
    -datatype date \
    -widget date \
    -optional

element create research_paper_create type \
    -label "Type" \
    -datatype text \
    -widget text \
    -optional

element create research_paper_create subject \
    -label "Subject" \
    -datatype text \
    -widget text \
    -optional

element create research_paper_create identifier \
    -label "Identifier" \
    -datatype text \
    -widget text \
    -optional

element create research_paper_create source \
    -label "Source" \
    -datatype text \
    -widget text \
    -optional

element create research_paper_create lang \
    -label "Language" \
    -datatype text \
    -widget text \
    -html {size 2 maxlength 2} \
    -optional

element create research_paper_create rights \
    -label "Rights" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 5 wrap soft} \
    -optional

if {[form is_valid research_paper_create]} {
    form get_values research_paper_create \
        revision_id return_url title abstract public_p \
        type subject identifier source lang paper_url publication_date

    # Get the date
    set publication_date [research_paper::to_sql_date -date $publication_date]
    
    # Hack for now
    set author_id [ad_get_user_id]

    set paper_id [research_paper::new \
        -revision_id $revision_id \
        -author_id $author_id \
        -title $title \
        -type $type \
        -subject $subject \
        -identifier $identifier \
        -source $source \
        -lang $lang \
        -paper_url $paper_url \
        -publication_date $publication_date \
        -abstract $abstract \
        -public_p $public_p]

    ad_returnredirect $return_url
}

set context_bar {{Create a Research Paper}}

ad_return_template
