ad_page_contract {
    Add paper to community
} -query {
    paper_id:integer,notnull
    return_url:notnull
}

form create select_community

element create select_community paper_id \
    -label PaperID \
    -datatype text \
    -widget hidden \
    -value $paper_id

element create select_community return_url \
        -label ReturnURL \
        -datatype text \
        -widget hidden \
        -value $return_url

set user_id [ad_get_user_id]
set communities [db_list_of_lists select_all_communities {}]

set n_communities [llength $communities]

if {$n_communities} {
    element create select_community community_id \
        -label "Share research paper with" \
        -datatype text \
        -widget select \
        -options "$communities"
} else {
    element create select_community community_id \
        -label "No groups to add to" \
        -datatype text \
        -widget hidden \
        -value ""
}

if {[form is_valid select_community]} {
    form get_values select_community \
        paper_id return_url community_id

    if {![empty_string_p $community_id]} {

        set approved_p f
        if {[dotlrn::user_can_admin_community_p -community_id $community_id]} {
            set approved_p t
        }

        attachments::attach -object_id $community_id -attachment_id $paper_id -approved_p $approved_p

    }

    ad_returnredirect $return_url
    ad_script_abort
}

ad_return_template
