ad_library {

    @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
    @creation-date 2002-08-29
    @version $Id: research-papers-procs.tcl,v 1.1 2003/11/14 20:57:06 janines Exp $

}

namespace eval research_paper {

    ad_proc -public new {
        {-revision_id ""}
        {-title:required}
	{-author_id:required}
	{-paper_url ""}
        {-abstract ""}
	{-publication_date ""}
	{-type ""}
	{-subject ""}
	{-identifier ""}
	{-source ""}
	{-lang ""}
	{-rights ""}
	{-license_url ""}
        {-public_p f}
    } {
        create a new research paper
    } {
        set extra_vars [ns_set create]
        oacs_util::vars_to_ns_set -ns_set $extra_vars -var_list {revision_id author_id title abstract publication_date type subject identifier source lang rights license_url public_p}

	db_transaction {
	    set paper_id [package_instantiate_object -extra_vars $extra_vars research_paper]

	    if {$public_p == "t"} {
		notify_paper -paper_id $paper_id
	    }
	}

	return $paper_id
    }

    ad_proc -public get {
        {-paper_id:required}
        {-array:required}
    } {
        get a research paper's meta data
    } {
        upvar $array row
        db_1row select_research_paper {} -column_array row
    }

    ad_proc -public edit {
        {-paper_id:required}
        {-revision_id:required}
        {-title:required}
        {-paper_url ""}
        {-abstract ""}
	{-publication_date ""}
	{-type ""}
	{-subject ""}
	{-identifier ""}
	{-source ""}
	{-lang ""}
	{-rights ""}
	{-license_url ""}
        {-public_p f}
    } {
        edit a research paper's meta data
    } {
	db_transaction {
	    db_dml update_research_paper {}

	    if {$public_p == "t"} {
		notify_paper -paper_id $paper_id
	    }
	}
    }

    ad_proc -public set_public_p {
	{-paper_id:required}
	{-public_p:required}
    } {
	set the public aspect of the paper
    } {
	db_transaction {
	    db_dml update_public_p {}

	    if {$public_p == "t"} {
		notify_paper -paper_id $paper_id
	    }
	}
    }

    ad_proc -public get_url {} {
        get the url for this package
    } {
        return knowledge
    }

    ad_proc -private notify_paper {
	{-paper_id:required}
    } {
	# Select information about the paper
	research_paper::get -paper_id $paper_id -array paper
	
	set author_id $paper(author_id)

	# Select information about the author
	oacs::user::get -user_id $author_id -array paper_author
	
	# Prepare the content
	set subject "New paper \"$paper(title)\" by $paper_author(first_names) $paper_author(last_name)"
	set text "$paper_author(first_names) $paper_author(last_name) ($paper_author(email)) has published a new paper entitled $paper(title)."

	ns_log Notice "BENHACK: about to create the notification"

	# Create the notification for authors
	notification::new \
		-type_id [notification::type::get_type_id -short_name research_author_notif_type] \
		-object_id $paper(author_id) \
		-notif_subject $subject \
		-notif_text $text
    }

}
