
#
# extra stuff for now
# (ben)
#

namespace eval research_paper {

    ad_proc -public from_sql_datetime {
        {-sql_date:required}
        {-format:required}
    } {

        if {[empty_string_p $sql_date]} {
            return ""
        }

        set date [template::util::date::create]

        switch -exact -- $format {
            {YYYY-MM-DD} {
                regexp {([0-9]*)-([0-9]*)-([0-9]*)} $sql_date all year month day

                set date [template::util::date::set_property format $date {DD MONTH YYYY}]
                set date [template::util::date::set_property year $date $year]
                set date [template::util::date::set_property month $date $month]
                set date [template::util::date::set_property day $date $day]
            }

            {HH12:MIam} {
                regexp {([0-9]*):([0-9]*) *([aApP][mM])} $sql_date all hours minutes ampm
                
                set date [template::util::date::set_property format $date {HH12:MI am}]
                set date [template::util::date::set_property hours $date $hours]
                set date [template::util::date::set_property minutes $date $minutes]                
                set date [template::util::date::set_property ampm $date [string tolower $ampm]]
            }

            {HH24:MI} {
                regexp {([0-9]*):([0-9]*)} $sql_date all hours minutes

                set date [template::util::date::set_property format $date {HH24:MI}]
                set date [template::util::date::set_property hours $date $hours]
                set date [template::util::date::set_property minutes $date $minutes]
            }

            {HH24} {
                set date [template::util::date::set_property format $date {HH24:MI}]
                set date [template::util::date::set_property hours $date $sql_date]
                set date [template::util::date::set_property minutes $date 0]
            }
        }

        return $date

    }

    ad_proc -public to_sql_date {
        {-date:required}
    } {
        This takes two date chunks, one for date one for time,
        and combines them correctly.

        The issue here is the incoming format.
        date: ANSI SQL YYYY-MM-DD
        time: we return HH24.
    } {
        set year [template::util::date::get_property year $date]
        set month [template::util::date::get_property month $date]
        set day [template::util::date::get_property day $date]

        # put together the timestamp
        return "$year-$month-$day"
    }

}
