#
#  Copyright (C) 2001, 2002 MIT
#
#  This file is part of dotLRN.
#
#  dotLRN is free software; you can redistribute it and/or modify it under the
#  terms of the GNU General Public License as published by the Free Software
#  Foundation; either version 2 of the License, or (at your option) any later
#  version.
#
#  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
#  details.
#

ad_library {

    portal theme procs

    @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
    @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
    @creation-date 2002-10-01
    @version $Id: theme-procs.tcl,v 1.4 2004/03/14 01:16:32 donb Exp $

}

namespace eval portal::theme {

    ad_proc -public get {
        {-theme_id:required}
    } {
        return a theme in "array get" format
    } {
        return [util_memoize "portal::theme::get_not_cached -theme_id $theme_id"]
    }

    ad_proc -private get_not_cached {
        {-theme_id:required}
    } {
        db_1row select_theme {} -column_array theme
        return [array get theme]
    }

    ad_proc -public get_id {
        {-name:required}
    } {
        Return a theme's id
 
        @name The name of the theme
        @return The theme_id

    } {
        return [db_string select_theme_id {}]
    }

}
