<?xml version="1.0"?>

<queryset>

    <fullquery name="portal::page::get_not_cached.select_page">
        <querytext>
            select *
            from portal_pages
            where page_id = :page_id
        </querytext>
    </fullquery>

    <fullquery name="portal::page::set_values.update_page">
        <querytext>
            update portal_pages
            set name = :name,
                portal_id = :portal_id,
                layout_id = :layout_id,
                sort_key = :sort_key
            where page_id = :page_id
        </querytext>
    </fullquery>

    <fullquery name="portal::page::has_visisble_elements.select_visible_elements">
        <querytext>
            select case when count(*) = 0 then 0 else 1 end
            from portal_elements
            where page_id = :page_id
            and state != 'hidden'
        </querytext>
    </fullquery>

    <fullquery name="portal::page::get_id.get_page_id_select">
        <querytext>
            select page_id
            from portal_pages
            where portal_id = :portal_id
            and sort_key = :sort_key
        </querytext>
    </fullquery>

    <fullquery name="portal::page::get_id.get_page_id_from_name">
        <querytext>
            select page_id
            from portal_pages
            where portal_id = :portal_id
            and name = :page_name
        </querytext>
    </fullquery>

    <fullquery name="portal::page::has_visible_elements.select_visible_elements_p">
        <querytext>
            select 1
            from dual
            where exists (select 1
                          from portal_elements
                          where page_id = :page_id
                          and state != 'hidden')
        </querytext>
    </fullquery>

    <fullquery name="portal::page::get_render_data.layout_select">
        <querytext>
            select portal_layouts.filename as layout_filename
            from portal_layouts
            where portal_layouts.layout_id = :layout_id
        </querytext>
    </fullquery>

    <fullquery name="portal::page::get_render_data.element_select">
        <querytext>
            select portal_elements.element_id,
                   portal_elements.region,
                   portal_elements.sort_key
            from portal_elements
            where portal_elements.page_id = :page_id
              and portal_elements.page_id = portal_pages.page_id
              and portal_elements.state != 'hidden'
            order by portal_elements.region,
                     portal_elements.sort_key
        </querytext>
    </fullquery>


</queryset>
