#
#  Copyright (C) 2001, 2002 MIT
#
#  This file is part of dotLRN.
#
#  dotLRN is free software; you can redistribute it and/or modify it under the
#  terms of the GNU General Public License as published by the Free Software
#  Foundation; either version 2 of the License, or (at your option) any later
#  version.
#
#  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
#  details.
#

ad_library {

    portal page procs

    @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
    @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
    @creation-date 2001-09-10
    @version $Id: page-procs.tcl,v 1.6 2004/03/14 01:16:32 donb Exp $

}

namespace eval portal::page {

    ad_proc -public new {
        {-portal_id:required}
        {-name:required}
        {-layout_name 2_column}
    } {
        Create a new page and associate it with the given portal_id
    } {
        set layout_id [portal::layout::get_id_from_name -name $layout_name]

        set var_list [list \
            [list portal_id $portal_id] \
            [list name $name] \
            [list layout_id $layout_id]]

        return [package_instantiate_object -var_list $var_list portal_page]
    }

    ad_proc -public delete {
        {-page_id:required}
    } {
        package_exec_plsql -var_list [list [list page_id $page_id]] portal_page del
    }

    ad_proc -public get {
        {-page_id:required}
    } {
        get page info in "array get" format (cached)
    } {
        return [util_memoize "portal::page::get_not_cached -page_id $page_id"]
    }

    ad_proc -private get_not_cached {
        {-page_id:required}
    } {
        db_1row select_page {} -column_array page
        return [array get page]
    }

    ad_proc -public set_values {
        {-page:required}
    } {
        set the fields of a portal page
    } {
        array set page_array $page
        template::util::array_to_vars page_array

        db_dml update_page {}
        util_memoize_flush "portal::page::get_not_cached -page_id $page_id"
    }

    ad_proc -public get_name {
        {-page_id:required}
    } {
        array set page [get -page_id $page_id]
        return $page(name)
    }

    ad_proc -public set_name {
        {-page_id:required}
        {-name:required}
    } {
        array set page [get -page_id $page_id]
        set page(name) $name

        set_values -page [array get page]
    }

    ad_proc -public get_portal_id {
        {-page_id:required}
    } {
        array set page [get -page_id $page_id]
        return $page(portal_id)
    }

    ad_proc -public get_layout_id {
        {-page_id:required}
    } {
        array set page [get -page_id $page_id]
        return $page(layout_id)
    }

    ad_proc -public set_layout_id {
        {-page_id:required}
        {-layout_id:required}
    } {
        array set page [get -page_id $page_id]
        set page(layout_id) $layout_id

        set_values -page [array get page]
    }

    ad_proc -public get_id {
        {-portal_id:required}
        {-page_name ""}
        {-sort_key 0}
    } {
        get the page_id given a portal_id and a page name. if no name is given
        the first page is returned.
    } {
        if {![empty_string_p $page_name]} {
            set page_id [db_string get_page_id_from_name {} -default ""]
            if {[empty_string_p $page_id]} {
                # there is no page by that name in the portal, return page 0
                return [get_id -portal_id $portal_id]
            } else {
                return $page_id
            }
        } else {
            return [db_string get_page_id_select {}]
        }
    }

    ad_proc -public first_page_p {
        {-portal_id:required}
        {-page_id:required}
    } {
        returns 1 if the given page_id is the first page in the given portal, otherwise 0.
    } {
        if {$page_id == [get_id -portal_id $portal_id -sort_key 0]} {
            return 1
        } else {
            return 0
        }
    }

    ad_proc -private has_visible_elements {
        {-page_id:required}
    } {
        return [db_string select_visible_elements_p {} -default 0]
    }

    ad_proc -private get_render_data {
        {-page_id:required}
        {-render_style individual} 
    } {
        array set page [get -page_id $page_id]
        set layout_id [get_layout_id -page_id $page_id]
        db_1row layout_select {}
        set page(layout_filename) "/packages/portal/lib/$layout_filename"

        set page(element_src) "/packages/portal/lib/render-styles/${render_style}/render-element"
        db_foreach element_select {} -column_array entry {
            lappend element_ids($entry(region)) $entry(element_id)
        } if_no_rows {
            set element_ids {}
        }

        set page(element_list) [array get element_ids]
        return [array get page]
    }

}
