#
#  Copyright (C) 2001, 2002 MIT
#
#  This file is part of dotLRN.
#
#  dotLRN is free software; you can redistribute it and/or modify it under the
#  terms of the GNU General Public License as published by the Free Software
#  Foundation; either version 2 of the License, or (at your option) any later
#  version.
#
#  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
#  details.
#

ad_library {

    portal layout procs

    @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
    @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
    @creation-date 2001-09-10
    @version $Id: layout-procs.tcl,v 1.1.1.1 2002/10/25 21:29:17 yon Exp $

}

namespace eval portal::layout {

    ad_proc -public get_region_count {
        {-layout_id:required}
    } {
        get the number of regions (aka columns) this layout supports
    } {
        return [util_memoize "portal::layout::get_region_count_not_cached -layout_id $layout_id"]
    }

    ad_proc -private get_region_count_not_cached {
        {-layout_id:required}
    } {
        return [db_string select_region_count {}]
    }

    ad_proc -public get_region_list {
        {-layout_id:required}
    } {
        get a list of the regions that a layout supports
    } {
        return [util_memoize "portal::layout::get_region_list_not_cached -layout_id $layout_id"]
    }

    ad_proc -private get_region_list_not_cached {
        {-layout_id:required}
    } {
        return [db_list select_region_list {}]
    }

    ad_proc -public get_layout_list {
    } {
        returns a list of all the layouts in the system as ns_sets with keys
        being: name, description, and number of regions.
    } {
        return [db_list_of_ns_sets select_layout_list {}]
    }

    ad_proc -public get_id_from_name {
        {-name:required}
    } {
        get the layout_id for the given layout name
    } {
        return [util_memoize "portal::layout::get_id_from_name_not_cached -name $name"]
    }

    ad_proc -private get_id_from_name_not_cached {
        {-name:required}
    } {
        return [db_string select_id_from_name {} -default ""]
    }

}
