<?xml version="1.0"?>

<queryset>

    <fullquery name="portal::element::new.select_region_count">
        <querytext>
            select count(*)
            from portal_elements,
                 portal_pages
            where portal_pages.page_id = :page_id
            and portal_pages.page_id = portal_elements.page_id
            and portal_elements.region = :region
        </querytext>
    </fullquery>

    <fullquery name="portal::element::new.select_template_element_id">
        <querytext>
            select portal_elements.element_id as template_element_id
            from portal_elements,
                 portal_pages,
                 portals
            where portal_elements.page_id = portal_pages.page_id
            and portal_pages.portal_id = portals.template_id
            and portals.portal_id = (select portal_id
                                     from portal_pages
                                     where page_id = :page_id)
            and portal_elements.datasource_id = :datasource_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::new.insert_element_with_template">
        <querytext>
            insert into portal_elements
            (element_id, datasource_id, name, page_id, region, sort_key, state, shadeable_p, hideable_p)
            select :element_id, :datasource_id, :name, :page_id, region, sort_key, state, shadeable_p, hideable_p
            from portal_elements
            where element_id = :template_element_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::delete.delete_element">
        <querytext>
            delete
            from portal_elements
            where element_id = :element_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::get.select_element">
        <querytext>
            select *
            from portal_elements
            where element_id = :element_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::set_values.update_element">
        <querytext>
            update portal_elements
            set datasource_id = :datasource_id,
                name = :name,
                page_id = :page_id,
                region = :region,
                sort_key = :sort_key,
                state = :state
            where element_id = :element_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::choose_region.select_region_count">
        <querytext>
            select count(*) as count
            from portal_elements pe,
                 portal_pages pp
            where pp.page_id = :page_id
            and pe.region = :region
            and pp.page_id = pe.page_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::get_list_from_datasource_name.select_element_ids">
        <querytext>
            select portal_elements.element_id
            from portal_elements,
                 portal_pages
            where portal_pages.portal_id = :portal_id
            and portal_elements.datasource_id = :datasource_id
            and portal_elements.page_id = portal_pages.page_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::move_vertically.swap_sort_keys_1">
        <querytext>
            update portal_elements
            set sort_key = :dummy_sort_key
            where element_id = :element_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::move_vertically.swap_sort_keys_2">
        <querytext>
            update portal_elements
            set sort_key = :sort_key
            where element_id = :other_element_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::move_vertically.swap_sort_keys_3">
        <querytext>
            update portal_elements
            set sort_key = :other_sort_key
            where element_id = :element_id
        </querytext>
    </fullquery>

</queryset>
