<?xml version="1.0"?>

<queryset>
    <rdbms><type>postgresql</type><version>7.2</version></rdbms>

    <fullquery name="portal::element::new.insert_element">
        <querytext>
            insert into portal_elements
            (element_id, datasource_id, name, page_id, region, state, sort_key,
             shadeable_p, hideable_p)
            select :element_id,
                   :datasource_id,
                   :name,
                   :page_id,
                   :region,
                   :state,
                   coalesce((select max(portal_elements.sort_key) + 1
                        from portal_elements
                        where page_id = :page_id
                        and region = :region), 1),
                   portal_datasources.shadeable_p,
                   portal_datasources.hideable_p
            from portal_datasources
            where portal_datasources.datasource_id = :datasource_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::new.insert_element_parameters">
        <querytext>
            insert into portal_element_parameters
              (parameter_id, element_id, config_required_p, configured_p, key, value)
            select nextval('portal_seq'), :element_id, config_required_p, configured_p, key, value
            from portal_datasource_parameters
            where datasource_id = :datasource_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::new.insert_element_parameters_with_template">
        <querytext>
            insert into portal_element_parameters
              (parameter_id, element_id, config_required_p, configured_p, key, value)
            select nextval('portal_seq'), :element_id, config_required_p, configured_p, key, value
            from portal_element_parameters
            where element_id = :template_element_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::move_vertically.select_previous_element">
        <querytext>
            select sort_key as other_sort_key,
                   element_id as other_element_id
            from (select *
                  from portal_elements
                  where page_id = :page_id
                  and region = :region
                  and sort_key < :sort_key
                  and state != 'pinned'
                  order by sort_key desc) as other_element
            limit 1
        </querytext>
    </fullquery>

    <fullquery name="portal::element::move_vertically.select_next_element">
        <querytext>
            select sort_key as other_sort_key,
                   element_id as other_element_id
            from (select *
                  from portal_elements
                  where page_id = :page_id
                  and region = :region
                  and sort_key > :sort_key
                  and state != 'pinned'
                  order by sort_key asc) as other_element
            limit 1
        </querytext>
    </fullquery>

    <fullquery name="portal::element::move_horizontally.update_region">
        <querytext>
            update portal_elements
            set region = :region,
                sort_key = (select coalesce((select max(sort_key) + 1
                                             from portal_elements
                                             where page_id = :page_id
                                             and region = :region),
                                            1)
                            from dual)
            where element_id = :element_id
        </querytext>
    </fullquery>

    <fullquery name="portal::element::move_to_page.update_element">
        <querytext>
            update portal_elements
            set page_id = :page_id,
                region = :region,
                sort_key = (select coalesce((select max(sort_key) + 1
                                             from portal_elements
                                             where page_id = :page_id
                                             and region = :region),
                                            1)
                            from dual)
            where element_id = :element_id
        </querytext>
    </fullquery>

</queryset>
