<?xml version="1.0"?>

<queryset>

    <fullquery name="portal::element::parameter::new.insert_parameter">
        <querytext>
            insert into portal_element_parameters
            (parameter_id, element_id, configured_p, key, value)
            select :parameter_id, :element_id, 't', :key, :value
            from dual
            where not exists (select parameter_id
                              from portal_element_parameters
                              where element_id = :element_id
                              and key = :key
                              and value= :value)
        </querytext>
    </fullquery>

    <fullquery name="portal::element::parameter::delete.delete_one_parameter_value">
        <querytext>
            delete
            from portal_element_parameters
            where element_id = :element_id
            and key = :key
            and value = :value
        </querytext>
    </fullquery>

    <fullquery name="portal::element::parameter::delete.delete_parameter">
        <querytext>
            delete
            from portal_element_parameters
            where element_id = :element_id
            and key = :key
        </querytext>
    </fullquery>

    <fullquery name="portal::element::parameter::get.select_parameters">
        <querytext>
            select value
            from portal_element_parameters
            where element_id = :element_id
            and key = :key
        </querytext>
    </fullquery>

    <fullquery name="portal::element::parameter::set_value.update_parameter">
        <querytext>
            update portal_element_parameters
            set value = :value
            where element_id = :element_id
            and key = :key
        </querytext>
    </fullquery>

    <fullquery name="portal::element::parameter::get_all.select_parameters">
        <querytext>
            select key,
                   value
            from portal_element_parameters
            where element_id = :element_id
        </querytext>
    </fullquery>

</queryset>
