#
#  Copyright (C) 2001, 2002 MIT
#
#  This file is part of dotLRN.
#
#  dotLRN is free software; you can redistribute it and/or modify it under the
#  terms of the GNU General Public License as published by the Free Software
#  Foundation; either version 2 of the License, or (at your option) any later
#  version.
#
#  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
#  details.
#

ad_library {

    portal element parameter procs

    @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
    @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
    @creation-date 2001-09-10
    @version $Id: element-parameter-procs.tcl,v 1.2 2004/03/12 04:54:04 donb Exp $

}

namespace eval portal::element::parameter {

    ad_proc -public new {
        {-element_id:required}
        {-key:required}
        {-value:required}
    } {
        new parameter value
    } {
        set parameter_id [db_nextval portal_seq]
        db_dml insert_parameter {}
    }

    ad_proc -private delete {
        {-element_id:required}
        {-key:required}
        {-value}
    } {
        removes a value for a parameter or all values for that parameter.
    } {
        if {[info exists $value]} {
            db_dml delete_one_parameter_value {}
        } else {
            db_dml delete_parameter {}
        }
    }

    ad_proc -public get {
        {-element_id:required}
        {-key:required}
    } {
        returns a list of values for this element/key combination
    } {
        return [db_list select_parameters {}]
    }

    ad_proc -public set_value {
        {-element_id:required}
        {-key:required}
        {-value:required}
    } {
        set the value of a parameter
    } {
        db_dml update_parameter {}
    }

    ad_proc -public get_all {
        {-element_id:required}
    } {
        return all parameters for element_id in "array get" format
    } {
        db_foreach select_parameters {} {
            lappend parameters($key) $value
        }

        return [array get parameters]
    }

    ad_proc -private toggle {
        {-element_id:required}
        {-key:required}
    } {
        toggles a boolean (t or f) parameter
    } {
        set value [lindex [get -element_id $element_id -key $key] 0]

        if {[string equal $value t]} {
            set_value -element_id $element_id -key $key -value f
        } elseif {[string equal $value f]} {
            set_value -element_id $element_id -key $key -value t
        }
    }

}
