namespace eval portal {}
namespace eval portal::install {}

ad_proc portal::install::package_install {} {
    Package installation callback proc
} {
    acs_sc::contract::new_from_spec -spec {
        name portal_datasource
        description "Portal datasource interface."
        operations {
            Initialize {
                description {
                    Configure datasource-specific parameters to reasonable values.
                }
                input {
                    element_id:integer
                }
                output {
                }
            }
        }
    }

    # Now define some default layouts.

    set var_list {
        {name 1_column}
        {description "One column"}
        {filename layouts/simple1}
    }
    set layout_id [package_instantiate_object -var_list $var_list portal_layout]

    set var_list [list \
        [list layout_id $layout_id] \
        [list region 1]]
    package_exec_plsql -var_list $var_list portal_layout add_region

    set var_list {
        {name 2_column}
        {description "Two columns"}
        {filename layouts/simple2}
    }
    set layout_id [package_instantiate_object -var_list $var_list portal_layout]

    set var_list [list \
        [list layout_id $layout_id] \
        [list region 1]]
    package_exec_plsql -var_list $var_list portal_layout add_region

    set var_list [list \
        [list layout_id $layout_id] \
        [list region 2]]
    package_exec_plsql -var_list $var_list portal_layout add_region

    set var_list {
        {name 3_column}
        {description "Three columns"}
        {filename layouts/simple3}
    }
    set layout_id [package_instantiate_object -var_list $var_list portal_layout]

    set var_list [list \
        [list layout_id $layout_id] \
        [list region 1]]
    package_exec_plsql -var_list $var_list portal_layout add_region

    set var_list [list \
        [list layout_id $layout_id] \
        [list region 2]]
    package_exec_plsql -var_list $var_list portal_layout add_region

    set var_list [list \
        [list layout_id $layout_id] \
        [list region 3]]
    package_exec_plsql -var_list $var_list portal_layout add_region

    # And some themes

    set var_list {
        {name default}
        {description "Default OpenACS Theme"}
        {filename themes/standard-theme}
        {resource_dir themes/standard-theme}
    }
    package_instantiate_object -var_list $var_list portal_theme

    set var_list {
        {name blank}
        {description "No graphics"}
        {filename themes/nada-theme}
        {resource_dir themes/nada-theme}
    }
    package_instantiate_object -var_list $var_list portal_theme

    set var_list {
        {name deco}
        {description "An Art Deco Theme"}
        {filename themes/deco-theme}
        {resource_dir themes/deco-theme}
    }
    package_instantiate_object -var_list $var_list portal_theme
    
}

ad_proc portal::install::package_uninstall {} {
    Uninstall portal_datasource service contract
} {
    acs_sc::contract::delete -name portal_datasource
}

