--
--  Copyright (C) 2001, 2002 MIT
--
--  This file is part of dotLRN.
--
--  dotLRN is free software; you can redistribute it and/or modify it under the
--  terms of the GNU General Public License as published by the Free Software
--  Foundation; either version 2 of the License, or (at your option) any later
--  version.
--
--  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
--  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
--  details.
--

--
-- create portal themes package
--
-- @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2001-10-01
-- @version $Id: theme-package-create.sql,v 1.3 2004/01/15 02:58:52 donb Exp $
--

select define_function_args('portal_theme__new', 'theme_id,name,description,filename,resource_dir,object_type;portal_theme,creation_date,creation_user,creation_ip,context_id');

create or replace function portal_theme__new (integer,varchar,varchar,varchar,varchar,varchar,timestamptz,integer,varchar,integer)
returns integer as '
declare
    p_theme_id                      alias for $1;
    p_name                          alias for $2;
    p_description                   alias for $3;
    p_filename                      alias for $4;
    p_resource_dir                  alias for $5;
    p_object_type                   alias for $6;
    p_creation_date                 alias for $7;
    p_creation_user                 alias for $8;
    p_creation_ip                   alias for $9;
    p_context_id                    alias for $10;
    v_theme_id                      portal_themes.theme_id%TYPE;
begin

    v_theme_id := acs_object__new(
        p_theme_id,
        p_object_type,
        p_creation_date,
        p_creation_user,
        p_creation_ip,
        p_context_id,
        ''t''
    );

    insert
    into portal_themes
    (theme_id, name, description, filename, resource_dir)
    values
    (v_theme_id, p_name, p_description, p_filename, p_resource_dir);

    return v_theme_id;

end;' language 'plpgsql';

create or replace function portal_theme__new (varchar,varchar,varchar,varchar)
returns integer as '
declare
    p_name                          alias for $1;
    p_description                   alias for $2;
    p_filename                      alias for $3;
    p_resource_dir                  alias for $4;
    v_theme_id                      portal_themes.theme_id%TYPE;
begin

    v_theme_id := portal_theme__new(
        null,
        p_name,
        p_description,
        p_filename,
        p_resource_dir,
        ''portal_theme'',
        now(),
        null,
        null,
        null
    );

    return v_theme_id;

end;' language 'plpgsql';

select define_function_args('portal_theme__del', 'theme_id');

create or replace function portal_theme__del(integer)
returns integer as '
    p_theme_id                      alias for $1;
begin

    perform acs_object__delete(p_theme_id);

    return 0;

end;' language 'plpgsql';
