--
--  Copyright (C) 2001, 2002 MIT
--
--  This file is part of dotLRN.
--
--  dotLRN is free software; you can redistribute it and/or modify it under the
--  terms of the GNU General Public License as published by the Free Software
--  Foundation; either version 2 of the License, or (at your option) any later
--  version.
--
--  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
--  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
--  details.
--

--
-- create portal layouts package
--
-- @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2001-10-01
-- @version $Id: layout-package-create.sql,v 1.3 2004/01/15 02:58:52 donb Exp $
--

select define_function_args('portal_layout__new', 'layout_id,name,description,filename,resource_dir,object_type;portal_layout,creation_date,creation_user,creation_ip,context_id');

create or replace function portal_layout__new (integer,varchar,varchar,varchar,varchar,varchar,timestamptz,integer,varchar,integer)
returns integer as '
declare
    p_layout_id                     alias for $1;  -- default null
    p_name                          alias for $2;
    p_description                   alias for $3;  -- default null
    p_filename                      alias for $4;
    p_resource_dir                  alias for $5;
    p_object_type                   alias for $6;  -- default ''portal_layout''
    p_creation_date                 alias for $7;  -- default current_timestamp
    p_creation_user                 alias for $8;  -- default null
    p_creation_ip                   alias for $9;  -- default null
    p_context_id                    alias for $10; -- default null
    v_layout_id                     portal_layouts.layout_id%TYPE;
    v_object_type                   acs_objects.object_type%TYPE;
    v_creation_date                 acs_objects.creation_date%TYPE;
begin
    v_object_type = coalesce(p_object_type, ''portal_layout'');
    v_creation_date = coalesce(p_creation_date, current_timestamp);

    v_layout_id := acs_object__new(
        p_layout_id,
        v_object_type,
        v_creation_date,
        p_creation_user,
        p_creation_ip,
        p_context_id,
        ''t''
    );

    insert into portal_layouts
    (layout_id, name, description, filename, resource_dir)
    values
    (v_layout_id, p_name, p_description, p_filename, p_resource_dir);

    return v_layout_id;

end;' language 'plpgsql';

select define_function_args('portal_layout__add_region', 'layout_id,region');

create or replace function portal_layout__add_region(integer,varchar)
returns integer as '
declare
    p_layout_id                     alias for $1;
    p_region                        alias for $2;
begin
    insert into portal_layout_regions
    (layout_id, region)
    values
    (p_layout_id, p_region);

    return 0;
end;' language 'plpgsql';


select define_function_args('portal_layout__del', 'layout_id');

create or replace function portal_layout__del(integer)
returns integer as '
declare
    p_layout_id                     alias for $1;
begin

    delete
    from portal_layouts
    where layout_id = p_layout_id;

    perform acs_object__delete(p_layout_id);

    return 0;

end;' language 'plpgsql';
