--
--  Copyright (C) 2001, 2002 MIT
--
--  This file is part of dotLRN.
--
--  dotLRN is free software; you can redistribute it and/or modify it under the
--  terms of the GNU General Public License as published by the Free Software
--  Foundation; either version 2 of the License, or (at your option) any later
--  version.
--
--  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
--  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
--  details.
--

--
-- create portal datasource package
--
-- @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2001-10-01
-- @version $Id: datasource-package-create.sql,v 1.6 2004/03/12 04:54:04 donb Exp $
--

select define_function_args('portal_datasource__new', 'name,pretty_name,application,owner,template,admin_p;f,shadeable_p;t,hideable_p;t,description');

create or replace function portal_datasource__new (varchar, varchar, varchar, varchar, varchar, varchar, varchar, varchar, varchar)
returns integer as '
declare
    p_name                          alias for $1;
    p_pretty_name                   alias for $2;
    p_application                   alias for $3;
    p_owner                         alias for $4;
    p_template                      alias for $5;
    p_admin_p                       alias for $6;
    p_shadeable_p                   alias for $7;
    p_hideable_p                    alias for $8;
    p_description                   alias for $9;
    v_datasource_id                 portal_datasources.datasource_id%TYPE;
begin

    v_datasource_id := nextval(''portal_seq'');

    insert into portal_datasources
    (datasource_id, name, pretty_name, application, owner, template, admin_p, shadeable_p, hideable_p, description)
    values
    (v_datasource_id, p_name, p_pretty_name, p_application, p_owner, p_template, p_admin_p, p_shadeable_p, p_hideable_p, p_description);

    return v_datasource_id;

end;' language 'plpgsql';

select define_function_args('portal_datasource__del', 'datasource_id');

create or replace function portal_datasource__del (integer)
returns integer as '
declare
    p_datasource_id                 alias for $1;
begin

    delete
    from portal_datasources
    where datasource_id = p_datasource_id;

    return 0;

end;' language 'plpgsql';

select define_function_args('portal_datasource__set_def_param', 'datasource_id,config_required_p,configured_p,key,value');

create or replace function portal_datasource__set_def_param (integer,varchar,varchar,varchar,varchar)
returns integer as '
declare
    p_datasource_id                 alias for $1;
    p_config_required_p             alias for $2;
    p_configured_p                  alias for $3;
    p_key                           alias for $4;
    p_value                         alias for $5;
begin

    insert into portal_datasource_parameters
    (datasource_id, config_required_p, configured_p, key, value)
    values
    (p_datasource_id, p_config_required_p, p_configured_p, p_key, p_value);

    return 0;

end;' language 'plpgsql';
