--
--  Copyright (C) 2001, 2002 MIT
--
--  This file is part of dotLRN.
--
--  dotLRN is free software; you can redistribute it and/or modify it under the
--  terms of the GNU General Public License as published by the Free Software
--  Foundation; either version 2 of the License, or (at your option) any later
--  version.
--
--  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
--  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
--  details.
--

--
-- create portal themes package
--
-- @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2001-10-01
-- @version $Id: theme-package-create.sql,v 1.2 2004/01/15 02:58:52 donb Exp $
--

create or replace package portal_theme
as

    function new (
        p_theme_id                  in portal_themes.theme_id%TYPE default null,
        p_name                      in portal_themes.name%TYPE,
        p_description               in portal_themes.description%TYPE default null,
        p_filename                  in portal_themes.filename%TYPE,
        p_resource_dir              in portal_themes.resource_dir%TYPE,
        p_object_type               in acs_objects.object_type%TYPE default 'portal_theme',
        p_creation_date             in acs_objects.creation_date%TYPE default sysdate,
        p_creation_user             in acs_objects.creation_user%TYPE default null,
        p_creation_ip               in acs_objects.creation_ip%TYPE default null,
        p_context_id                in acs_objects.context_id%TYPE default null
    ) return portal_themes.theme_id%TYPE;

    procedure del (
        p_theme_id                  in portal_themes.theme_id%TYPE
    );

end portal_theme;
/
show errors

create or replace package body portal_theme
as

    function new (
        p_theme_id                  in portal_themes.theme_id%TYPE default null,
        p_name                      in portal_themes.name%TYPE,
        p_description               in portal_themes.description%TYPE default null,
        p_filename                  in portal_themes.filename%TYPE,
        p_resource_dir              in portal_themes.resource_dir%TYPE,
        p_object_type               in acs_objects.object_type%TYPE default 'portal_theme',
        p_creation_date             in acs_objects.creation_date%TYPE default sysdate,
        p_creation_user             in acs_objects.creation_user%TYPE default null,
        p_creation_ip               in acs_objects.creation_ip%TYPE default null,
        p_context_id                in acs_objects.context_id%TYPE default null
    ) return portal_themes.theme_id%TYPE
    is
        v_theme_id                  portal_themes.theme_id%TYPE;
    begin

        v_theme_id := acs_object.new(
            object_id => p_theme_id,
            object_type => p_object_type,
            creation_date => p_creation_date,
            creation_user => p_creation_user,
            creation_ip => p_creation_ip,
            context_id => p_context_id
        );

        insert
        into portal_themes
        (theme_id, name, description, filename, resource_dir)
        values
        (v_theme_id, p_name, p_description, p_filename, p_resource_dir);

        return v_theme_id;

    end new;

    procedure del (
        p_theme_id                  in portal_themes.theme_id%TYPE
    )
    is
    begin
        acs_object.del(p_theme_id);
    end del;

end portal_theme;
/
show errors
