--
--  Copyright (C) 2001, 2002 MIT
--
--  This file is part of dotLRN.
--
--  dotLRN is free software; you can redistribute it and/or modify it under the
--  terms of the GNU General Public License as published by the Free Software
--  Foundation; either version 2 of the License, or (at your option) any later
--  version.
--
--  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
--  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
--  details.
--

--
-- create portals package
--
-- @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2001-10-01
-- @version $Id: portal-package-create.sql,v 1.3 2004/01/15 02:58:52 donb Exp $
--

create or replace package portal
as

    function new (
        p_portal_id                 in portals.portal_id%TYPE default null,
        p_party_id                  in parties.party_id%TYPE,
        p_name                      in portals.name%TYPE default 'Untitled',
        p_theme_id                  in portals.theme_id%TYPE default null,
        p_template_id               in portals.template_id%TYPE default null,
        p_object_type               in acs_objects.object_type%TYPE default 'portal',
        p_creation_date             in acs_objects.creation_date%TYPE default sysdate,
        p_creation_user             in acs_objects.creation_user%TYPE default null,
        p_creation_ip               in acs_objects.creation_ip%TYPE default null,
        p_context_id                in acs_objects.context_id%TYPE default null
    ) return portals.portal_id%TYPE;

    procedure del (
        p_portal_id                 in portals.portal_id%TYPE
    );

end portal;
/
show errors

create or replace package body portal
as

    function new (
        p_portal_id                 in portals.portal_id%TYPE default null,
        p_party_id                  in parties.party_id%TYPE,
        p_name                      in portals.name%TYPE default 'Untitled',
        p_theme_id                  in portals.theme_id%TYPE default null,
        p_template_id               in portals.template_id%TYPE default null,
        p_object_type               in acs_objects.object_type%TYPE default 'portal',
        p_creation_date             in acs_objects.creation_date%TYPE default sysdate,
        p_creation_user             in acs_objects.creation_user%TYPE default null,
        p_creation_ip               in acs_objects.creation_ip%TYPE default null,
        p_context_id                in acs_objects.context_id%TYPE default null
    ) return portals.portal_id%TYPE
    is
        v_portal_id                 portals.portal_id%TYPE;
        v_theme_id                  portals.theme_id%TYPE;
        v_page_id                   portal_pages.page_id%TYPE;
        v_new_element_id            portal_elements.element_id%TYPE;
        v_new_parameter_id          portal_element_parameters.parameter_id%TYPE;
    begin

        v_portal_id := acs_object.new(
            object_id  => p_portal_id,
            object_type => p_object_type,
            creation_date => p_creation_date,
            creation_user => p_creation_user,
            creation_ip => p_creation_ip,
            context_id => p_context_id
        );

        if template_id is null then

            if p_theme_id is null then
                select max(theme_id)
                into v_theme_id
                from portal_themes;
            else
                v_theme_id := p_theme_id;
            end if;

            insert
            into portals
            (portal_id, party_id, name, theme_id)
            values
            (v_portal_id, p_party_id, p_name, v_theme_id);

        else

            -- we have a portal as our template. copy it's theme, pages, layouts,
            -- elements, and element params.
            select theme_id
            into v_theme_id
            from portals
            where portal_id = p_template_id;

            insert
            into portals
            (portal_id, party_id, name, theme_id, template_id)
            values
            (v_portal_id, p_party_id, p_name, v_theme_id, p_template_id);

            -- now insert the pages from the portal template
            for v_page in (select *
                           from portal_pages
                           where portal_id = p_template_id)
            loop

                v_page_id := portal_page.new(
                    name => v_page.name,
                    portal_id => v_portal_id,
                    layout_id => v_page.layout_id
                    creation_date => p_creation_date,
                    creation_user => p_creation_user,
                    creation_ip => p_creation_ip,
                    context_id => v_portal_id
                );

                -- now get the elements on the template's page and put them on the new page
                for v_element in (select *
                                  from portal_elements
                                  where page_id = v_page.page_id)
                loop

                    select portal_seq.nextval
                    into v_new_element_id
                    from dual;

                    insert
                    into portal_elements
                    (element_id, name, page_id, datasource_id, region, sort_key, state, shadeable_p, hideable_p)
                    select v_new_element_id, name, v_page_id, datasource_id, region, sort_key, state, shadeable_p, hideable_p
                    from portal_elements
                    where element_id = v_element.element_id;

                    -- now for the element's params
                    for v_param in (select *
                                    from portal_element_parameters
                                    where element_id = v_element.element_id)
                    loop

                        select portal_seq.nextval
                        into v_new_parameter_id
                        from dual;

                        insert
                        into portal_element_parameters
                        (parameter_id, element_id, config_required_p, configured_p, key, value)
                        select v_new_parameter_id, v_new_element_id, config_required_p, configured_p, key, value
                        from portal_element_parameters
                        where parameter_id = v_param.parameter_id;

                    end loop;

                end loop;

            end loop;

        end if;

        return v_portal_id;

    end new;

    procedure del (
        p_portal_id                 in portals.portal_id%TYPE
    )
    is
    begin

        for v_page in (select page_id
                       from portal_pages
                       where portal_id = p_portal_id
                       order by sort_key desc)
        loop
            portal_page.del(v_page.page_id);
        end loop;

        delete
        from portals
        where portal_id = p_portal_id;

        acs_object.del(p_portal_id);

    end del;

end portal;
/
show errors
