--
--  Copyright (C) 2001, 2002 MIT
--
--  This file is part of dotLRN.
--
--  dotLRN is free software; you can redistribute it and/or modify it under the
--  terms of the GNU General Public License as published by the Free Software
--  Foundation; either version 2 of the License, or (at your option) any later
--  version.
--
--  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
--  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
--  details.
--

--
-- create portal metadata
--
-- @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2001-10-01
-- @version $Id: objects-create.sql,v 1.2 2004/03/14 00:03:32 donb Exp $
--

begin
    acs_object_type.create_type(
        supertype     => 'acs_object',
        object_type   => 'portal',
        pretty_name   => 'Portal',
        pretty_plural => 'Portals',
        table_name    => 'PORTALS',
        id_column     => 'PORTAL_ID',
        package_name  => 'portal'
    );
end;
/
show errors;

begin
    acs_object_type.create_type(
        supertype     => 'acs_object',
        object_type   => 'portal_theme',
        pretty_name   => 'Portal Theme',
        pretty_plural => 'Portal Themes',
        table_name    => 'PORTAL_THEMES',
        id_column     => 'THEME_ID',
        package_name  => 'portal_theme'
    );
end;
/
show errors;

begin
    acs_object_type.create_type(
        supertype     => 'acs_object',
        object_type   => 'portal_page',
        pretty_name   => 'Portal Page',
        pretty_plural => 'Portal Pages',
        table_name    => 'PORTAL_PAGES',
        id_column     => 'PAGE_ID',
        package_name  => 'portal_page'
    );
end;
/
show errors;

begin
    acs_object_type.create_type(
        supertype => 'acs_object',
        object_type => 'portal_layout',
        pretty_name => 'Portal Layout',
        pretty_plural => 'Portal Layouts',
        table_name => 'PORTAL_LAYOUTS',
        id_column => 'LAYOUT_ID',
        package_name => 'portal_layout'
    );
end;
/
show errors;
