--
--  Copyright (C) 2001, 2002 MIT
--
--  This file is part of dotLRN.
--
--  dotLRN is free software; you can redistribute it and/or modify it under the
--  terms of the GNU General Public License as published by the Free Software
--  Foundation; either version 2 of the License, or (at your option) any later
--  version.
--
--  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
--  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
--  details.
--

--
-- create portal layouts package
--
-- @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2001-10-01
-- @version $Id: layout-package-create.sql,v 1.3 2004/01/15 02:58:52 donb Exp $
--

create or replace package portal_layout
as

    function new (
        p_layout_id                 in portal_layouts.layout_id%TYPE default null,
        p_name                      in portal_layouts.name%TYPE,
        p_description               in portal_layouts.description%TYPE default null,
        p_filename                  in portal_layouts.filename%TYPE,
        p_resource_dir              in portal_layouts.resource_dir%TYPE,
        p_object_type               in acs_objects.object_type%TYPE default 'portal_layout',
        p_creation_date             in acs_objects.creation_date%TYPE default sysdate,
        p_creation_user             in acs_objects.creation_user%TYPE default null,
        p_creation_ip               in acs_objects.creation_ip%TYPE default null,
        p_context_id                in acs_objects.context_id%TYPE default null
    ) return portal_layouts.layout_id%TYPE;

    procedure add_region (
        p_layout_id                 in portal_layout_regions.layout_id%TYPE,
        p_region                    in portal_layout_regions.region%TYPE
    );

    procedure del (
        p_layout_id                 in portal_layouts.layout_id%TYPE
    );

end portal_layout;
/
show errors

create or replace package body portal_layout
as

    function new (
        p_layout_id                 in portal_layouts.layout_id%TYPE default null,
        p_name                      in portal_layouts.name%TYPE,
        p_description               in portal_layouts.description%TYPE default null,
        p_filename                  in portal_layouts.filename%TYPE,
        p_resource_dir              in portal_layouts.resource_dir%TYPE,
        p_object_type               in acs_objects.object_type%TYPE default 'portal_layout',
        p_creation_date             in acs_objects.creation_date%TYPE default sysdate,
        p_creation_user             in acs_objects.creation_user%TYPE default null,
        p_creation_ip               in acs_objects.creation_ip%TYPE default null,
        p_context_id                in acs_objects.context_id%TYPE default null
    ) return portal_layouts.layout_id%TYPE
    is
        v_layout_id                 portal_layouts.layout_id%TYPE;
    begin

        v_layout_id := acs_object.new(
            object_id => p_layout_id,
            object_type => p_object_type,
            creation_date => p_creation_date,
            creation_user => p_creation_user,
            creation_ip => p_creation_ip,
            context_id => p_context_id
        );

        insert into portal_layouts
        (layout_id, name, description, filename, resource_dir)
        values
        (v_layout_id, p_name, p_description, p_filename, p_resource_dir);

        return v_layout_id;

    end new;

    procedure add_region (
        p_layout_id                 in portal_layout_regions.layout_id%TYPE,
        p_region                    in portal_layout_regions.region%TYPE
    )
    is
    begin
        insert into portal_layout_regions
        (layout_id, region)
        values
        (p_layout_id, p_region);
    end add_region;


    procedure del (
        p_layout_id                 in portal_layouts.layout_id%TYPE
    )
    is
    begin

        delete
        from portal_layouts
        where layout_id = p_layout_id;

        acs_object.del(p_layout_id);

    end del;

end portal_layout;
/
show errors
