--
--  Copyright (C) 2001, 2002 MIT
--
--  This file is part of dotLRN.
--
--  dotLRN is free software; you can redistribute it and/or modify it under the
--  terms of the GNU General Public License as published by the Free Software
--  Foundation; either version 2 of the License, or (at your option) any later
--  version.
--
--  dotLRN is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
--  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
--  details.
--

--
-- create portal datasource package
--
-- @author <a href="mailto:arjun@openforce.net">arjun@openforce.net</a>
-- @author <a href="mailto:yon@openforce.net">yon@openforce.net</a>
-- @creation-date 2001-10-01
-- @version $Id: datasource-package-create.sql,v 1.3 2004/01/15 02:58:52 donb Exp $
--

create or replace package portal_datasource
as

    function new (
        p_name                      in portal_datasources.name%TYPE,
        p_shadeable_p               in portal_datasources.shadeable_p%TYPE default 't'
        p_hideable_p                in portal_datasources.hideable_p%TYPE default 't'
        p_description               in portal_datasources.description%TYPE default null
    ) return portal_datasources.datasource_id%TYPE;

    procedure del (
        p_datasource_id             in portal_datasources.datasource_id%TYPE
    );

    procedure set_def_param (
        p_datasource_id             in portal_datasource_parameters.datasource_id%TYPE,
        p_config_required_p         in portal_datasource_parameters.config_required_p%TYPE default null,
        p_configured_p              in portal_datasource_parameters.configured_p%TYPE default null,
        p_key                       in portal_datasource_parameters.key%TYPE,
        p_value                     in portal_datasource_parameters.value%TYPE default null
    );

end portal_datasource;
/
show errors

create or replace package body portal_datasource
as

    function new (
        p_name                      in portal_datasources.name%TYPE,
        p_shadeable_p               in portal_datasources.shadeable_p%TYPE default 't'
        p_hideable_p                in portal_datasources.hideable_p%TYPE default 't'
        p_description               in portal_datasources.description%TYPE default null
    ) return portal_datasources.datasource_id%TYPE
    is
        v_datasource_id             portal_datasources.datasource_id%TYPE;
    begin

        insert into portal_datasources
        (datasource_id, name, shadeable_p, hideable_p, description)
        values
        (portal_seq.nextval, p_name, p_shadeable_p, p_hideable_p, p_description)
        returning datasource_id
        into v_datasource_id;

        return v_datasource_id;

    end new;

    procedure del (
        p_datasource_id             in portal_datasources.datasource_id%TYPE
    )
    is
    begin

        delete
        from portal_datasources
        where datasource_id = p_datasource_id;

    end del;

    procedure set_def_param (
        p_datasource_id             in portal_datasource_parameters.datasource_id%TYPE,
        p_config_required_p         in portal_datasource_parameters.config_required_p%TYPE default null,
        p_configured_p              in portal_datasource_parameters.configured_p%TYPE default null,
        p_key                       in portal_datasource_parameters.key%TYPE,
        p_value                     in portal_datasource_parameters.value%TYPE default null
    )
    is
    begin

        insert into portal_datasource_parameters
        (datasource_id, config_required_p, configured_p, key, value)
        values
        (p_datasource_id, p_config_required_p, p_configured_p, p_key, p_value);

    end set_def_param;

end portal_datasource;
/
show errors
