# Expects properties:
#   title
#   focus
#   header_stuff
#   section
#   subnavbar_link

ns_log Notice "Huh? starting master ..."

if { ![info exists section] } {
    set section {}
}

if { ![info exists header_stuff] } {
    set header_stuff {}
}

if { ![info exists subnavbar_link] } {
    set subnavbar_link {}
}

set subsite_id [ad_conn subsite_id]
db_1row select_package_id {}

ns_log Notice "Huh? package_id: $package_id"
set user_portal_id [portal::get_user_portal_id -package_id $package_id]
if { ![info exists portal_id] } {
    set portal_id $user_portal_id
}

db_multirow -unclobber -extend {url} navbar select_user_navbar {} {
    set url [export_vars -base index {page_num page_num}]
}

if { [permission::permission_p \
        -object_id [portal::get_admin_portal_id -package_id $package_id] \
        -privilege admin] } {
    db_multirow -unclobber -append -extend {url} navbar select_admin_navbar {} {
        set url [export_vars -base index {portal_id page_num}]
    }
}
ns_log Notice "Huh? done with portal part of master ..."

# This will set 'sections' and 'subsections' multirows
subsite_integration::define_pageflow -section $section
subsite_integration::get_section_info -array section_info

# Find the subsite we belong to
set subsite_url [site_node_closest_ancestor_package_url]
array set subsite_sitenode [site_node::get -url $subsite_url]
set subsite_node_id $subsite_sitenode(node_id)
set subsite_name $subsite_sitenode(instance_name)

# Where to find the stylesheet
set css_url "/resources/acs-subsite/group-master.css"

if { [string equal [ad_conn url] $subsite_url] } {
    set subsite_url {}
}
ns_log Notice "Huh? done with master ..."
