<?xml version="1.0"?>

<queryset>

  <fullquery name="select_prev_page_id">
    <querytext>
        select page_id as prev_page_id
        from portal_pages
        where portal_id = :portal_id
          and sort_key = (select sort_key - 1
                          from portal_pages
                          where page_id = :page_id)
    </querytext>
  </fullquery>

  <fullquery name="select_next_page_id">
    <querytext>
        select page_id as next_page_id
        from portal_pages
        where portal_id = :portal_id
          and sort_key = (select sort_key + 1
                          from portal_pages
                          where page_id = :page_id)
    </querytext>
  </fullquery>

  <fullquery name="select_element_count">
    <querytext>
      select count(*) as element_count
      from portal_elements
      where page_id = :page_id
        and region = :region
        and state <> 'hidden'
    </querytext>
  </fullquery>

  <fullquery name="select_elements">
    <querytext>
      select element_id, name, sort_key, state, hideable_p
      from portal_elements
      where page_id = :page_id
        and region = :region
        and state <> 'hidden'
      order by sort_key
    </querytext>
  </fullquery>

</queryset>
