ad_page_contract {

    Configure a portal page region (i.e. column)

    @author Don Baccus (dhogaza@pacifier.com)

}

set return_url [ad_conn url]?[ad_conn query]

array set page $page_list

# queries need these as a bindvar ...
set page_id $page(page_id)
set portal_id $page(portal_id)

# See if there's a page before this one
if { $page(sort_key) > 0 } {
    db_1row select_prev_page_id {}
} else {
    set prev_page_id ""
}

# See if there's a page after this one (sort_key starts at zero)
if { $page(sort_key) + 1 < [portal::get_page_count -portal_id $portal_id] } {
    db_1row select_next_page_id {}
} else {
    set next_page_id ""
}

# Grab all the element information and compute the various motion options

set element_num 1
db_1row select_element_count {}
db_multirow -extend {hide_url up_url down_url left_url right_url} elements select_elements {} {

    set up_url ""
    set down_url ""
    set left_url ""
    set right_url ""

    # Set up the "hide" option
    if { [string is true $hideable_p] } {
        set hide_url \
            [export_vars -base [ad_conn package_url]portal-configure-2 \
                {{op hide} portal_id page_id element_id return_url}]
    } else {
        set hide_url ""
    }

    # Set up the "move up" option if possible
    if { $element_num > 1} {
        set up_url \
            [export_vars -base [ad_conn package_url]portal-configure-2 \
                {{op move_up} portal_id element_id page_id return_url}]
    } elseif { ![string equal $prev_page_id ""] } {
        set up_url \
            [export_vars -base [ad_conn package_url]portal-configure-2 \
                {{op move_to_page} portal_id element_id {page_id $prev_page_id} return_url}]
    }

    # Set up the "move down" option if possible
    if { $element_num < $element_count } {
        set down_url \
            [export_vars -base [ad_conn package_url]portal-configure-2 \
                {{op move_down} portal_id element_id page_id return_url}]
    } elseif { ![string equal $next_page_id ""] } {
        set down_url \
            [export_vars -base [ad_conn package_url]portal-configure-2 \
                {{op move_to_page} portal_id element_id {page_id $next_page_id} return_url}]
    }

    # If there's more than one region, let the user move the portlet to the right or left
    if { $region_count > 1 } {

        # if there's space to the right, let them move the portlet right
        if { $region < $region_count } {
            set right_url \
                [export_vars -base [ad_conn package_url]portal-configure-2 \
                    {{op move_right} portal_id element_id region return_url}]
        }

        # If there's space to the left, let them move the portlet left 
        if { $region > 1 } {
            set left_url \
                [export_vars -base [ad_conn package_url]portal-configure-2 \
                    {{op move_left} portal_id element_id region return_url}]
        }
    }

    incr element_num
}
