ad_page_contract {

    Configure a portal

    @author Don Baccus (dhogaza@pacifier.com)

} {
}

set return_url [ad_conn url]?[ad_conn query]
set package_url [ad_conn package_url]

# If we're called from the configuration wizard, portal_id is not defined but we
# know we're configuting the master template.

if { ![info exists portal_id] } {
    set portal_id [portal::get_master_template_id]
}

set current_theme_id [portal::get_theme_id -portal_id $portal_id]
set first_page_id [lindex [portal::get_page_list -portal_id $portal_id] 0]
db_multirow themes select_themes {}
db_multirow hidden_elements select_hidden_elements {}
db_multirow page_ids select_page_ids {}
set page_count [portal::get_page_count -portal_id $portal_id]
set new_page_num [expr {$page_count + 1}]
set template_id [portal::get_template_id -portal_id $portal_id]

# Now, if we're in the template wizard, generate the wizard form and buttons.
 
set wizard_p [template::wizard::exists]
if { $wizard_p } {

    ad_form -name add-applications -form {
        foo:text(hidden),optional
    } -on_submit {
        template::wizard::forward
    }

    template::wizard::submit add-applications -buttons {back next}
}

ad_return_template
